/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.whirr.service.ClusterActionHandler;
import org.apache.whirr.service.hadoop.HadoopDataNodeClusterActionHandler;
import org.apache.whirr.service.hadoop.HadoopJobTrackerClusterActionHandler;
import org.apache.whirr.service.hadoop.HadoopNameNodeClusterActionHandler;
import org.apache.whirr.service.hadoop.HadoopTaskTrackerClusterActionHandler;
import org.jclouds.scriptbuilder.functionloader.osgi.BundleFunctionLoader;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleFunctionLoader functionLoader;
    private final ClusterActionHandler dataNodeClusterActionHandler = new HadoopDataNodeClusterActionHandler();
    private ServiceRegistration dataNodeRegistration;
    private final ClusterActionHandler nameNodeClusterActionHandler = new HadoopNameNodeClusterActionHandler();
    private ServiceRegistration nameNodeRegistration;
    private final ClusterActionHandler jobTrackerClusterActionHandler = new HadoopJobTrackerClusterActionHandler();
    private ServiceRegistration jobTrackerRegistration;
    private final ClusterActionHandler taskTrackerClusterActionHandler = new HadoopTaskTrackerClusterActionHandler();
    private ServiceRegistration taskTrackerRegistration;

    public void start(BundleContext context) throws Exception {
        this.functionLoader = new BundleFunctionLoader(context);
        this.functionLoader.start();
        Properties dataNodeProps = new Properties();
        dataNodeProps.put("name", "hadoop-datanode");
        this.dataNodeRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.dataNodeClusterActionHandler, (Dictionary)dataNodeProps);
        Properties nameNodeProps = new Properties();
        nameNodeProps.put("name", "hadoop-namenode");
        this.nameNodeRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.nameNodeClusterActionHandler, (Dictionary)nameNodeProps);
        Properties jobTrackerProps = new Properties();
        jobTrackerProps.put("name", "hadoop-jobtracker");
        this.jobTrackerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.jobTrackerClusterActionHandler, (Dictionary)jobTrackerProps);
        Properties taskTrackerProps = new Properties();
        taskTrackerProps.put("name", "hadoop-tasktracker");
        this.taskTrackerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.taskTrackerClusterActionHandler, (Dictionary)taskTrackerProps);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.dataNodeRegistration != null) {
            this.dataNodeRegistration.unregister();
        }
        if (this.nameNodeRegistration != null) {
            this.nameNodeRegistration.unregister();
        }
        if (this.jobTrackerRegistration != null) {
            this.jobTrackerRegistration.unregister();
        }
        if (this.taskTrackerRegistration != null) {
            this.taskTrackerRegistration.unregister();
        }
        if (this.functionLoader != null) {
            this.functionLoader.stop();
        }
    }
}

