/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Volume;

public class VolumeManager {
    public static final String MOUNT_PREFIX = "/data";

    public Map<String, String> getDeviceMappings(ClusterSpec clusterSpec, Cluster.Instance instance) {
        LinkedHashMap mappings = Maps.newLinkedHashMap();
        int number = 0;
        Hardware hardware = instance.getNodeMetadata().getHardware();
        if (hardware != null) {
            List volumes = instance.getNodeMetadata().getHardware().getVolumes();
            for (Volume volume : volumes) {
                if (volume.isBootDevice()) continue;
                mappings.put(MOUNT_PREFIX + number++, volume.getDevice());
            }
        }
        return mappings;
    }

    public static String asString(Map<String, String> deviceMappings) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> mapping : deviceMappings.entrySet()) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(mapping.getKey()).append(",").append(mapping.getValue());
        }
        return sb.toString();
    }
}

