/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import java.io.IOException;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopCluster;
import org.apache.whirr.service.hadoop.HadoopClusterActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTaskTrackerClusterActionHandler
extends HadoopClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTaskTrackerClusterActionHandler.class);
    public static final String ROLE = "hadoop-tasktracker";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster cluster = event.getCluster();
        Cluster.Instance jobtracker = cluster.getInstanceMatching(RolePredicates.role((String)"hadoop-jobtracker"));
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(jobtracker).ports(new int[]{50030}), FirewallManager.Rule.create().source(HadoopCluster.getNamenodePublicAddress(cluster).getHostAddress()).destination(jobtracker).ports(new int[]{8021})});
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
    }
}

