/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopCluster;
import org.apache.whirr.service.hadoop.HadoopClusterActionHandler;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.apache.whirr.service.hadoop.HadoopProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopNameNodeClusterActionHandler
extends HadoopClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopNameNodeClusterActionHandler.class);
    public static final String ROLE = "hadoop-namenode";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster cluster = event.getCluster();
        Cluster.Instance namenode = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(namenode).ports(new int[]{50070}), FirewallManager.Rule.create().source(namenode.getPublicAddress().getHostAddress()).destination(namenode).ports(new int[]{8020, 8021})});
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        InetAddress namenodePublicAddress = HadoopCluster.getNamenodePublicAddress(cluster);
        InetAddress jobtrackerPublicAddress = HadoopCluster.getJobTrackerPublicAddress(cluster);
        LOG.info("Namenode web UI available at http://{}:{}", (Object)namenodePublicAddress.getHostName(), (Object)50070);
        Properties config = this.createClientSideProperties(clusterSpec, namenodePublicAddress, jobtrackerPublicAddress);
        this.createClientSideHadoopSiteFile(clusterSpec, config);
        this.createProxyScript(clusterSpec, cluster);
        Properties combined = new Properties();
        combined.putAll((Map<?, ?>)cluster.getConfiguration());
        combined.putAll((Map<?, ?>)config);
        event.setCluster(new Cluster(cluster.getInstances(), combined));
    }

    private Properties createClientSideProperties(ClusterSpec clusterSpec, InetAddress namenode, InetAddress jobtracker) throws IOException {
        Properties config = new Properties();
        config.setProperty("hadoop.job.ugi", "root,root");
        config.setProperty("fs.default.name", String.format("hdfs://%s:8020/", namenode.getHostName()));
        if (jobtracker != null) {
            config.setProperty("mapred.job.tracker", String.format("%s:8021", jobtracker.getHostName()));
        }
        config.setProperty("hadoop.socks.server", "localhost:6666");
        config.setProperty("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.SocksSocketFactory");
        config.setProperty("dfs.client.use.legacy.blockreader", "true");
        if (clusterSpec.getProvider().endsWith("ec2")) {
            config.setProperty("fs.s3.awsAccessKeyId", clusterSpec.getIdentity());
            config.setProperty("fs.s3.awsSecretAccessKey", clusterSpec.getCredential());
            config.setProperty("fs.s3n.awsAccessKeyId", clusterSpec.getIdentity());
            config.setProperty("fs.s3n.awsSecretAccessKey", clusterSpec.getCredential());
        }
        return config;
    }

    private void createClientSideHadoopSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = this.getConfigDir(clusterSpec);
        File hadoopSiteFile = new File(configDir, "hadoop-site.xml");
        HadoopConfigurationConverter.createClientSideHadoopSiteFile(hadoopSiteFile, config);
    }

    private File getConfigDir(ClusterSpec clusterSpec) {
        File configDir = new File(new File(System.getProperty("user.home")), ".whirr");
        configDir = new File(configDir, clusterSpec.getClusterName());
        configDir.mkdirs();
        return configDir;
    }

    private void createProxyScript(ClusterSpec clusterSpec, Cluster cluster) {
        File configDir = this.getConfigDir(clusterSpec);
        File hadoopProxyFile = new File(configDir, "hadoop-proxy.sh");
        try {
            HadoopProxy proxy = new HadoopProxy(clusterSpec, cluster);
            InetAddress namenode = HadoopCluster.getNamenodePublicAddress(cluster);
            String script = String.format("echo 'Running proxy to Hadoop cluster at %s. Use Ctrl-c to quit.'\n", namenode.getHostName()) + Joiner.on((String)" ").join((Object[])proxy.getProxyCommand());
            Files.write((CharSequence)script, (File)hadoopProxyFile, (Charset)Charsets.UTF_8);
            hadoopProxyFile.setExecutable(true);
            LOG.info("Wrote Hadoop proxy script {}", (Object)hadoopProxyFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing Hadoop proxy script {}", (Object)hadoopProxyFile, (Object)e);
        }
    }
}

