/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopCluster;
import org.apache.whirr.service.hadoop.HadoopNameNodeClusterActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopJobTrackerClusterActionHandler
extends HadoopNameNodeClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopJobTrackerClusterActionHandler.class);
    public static final String ROLE = "hadoop-jobtracker";

    @Override
    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster cluster = event.getCluster();
        Cluster.Instance jobtracker = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(jobtracker).ports(new int[]{50030}), FirewallManager.Rule.create().source(HadoopCluster.getNamenodePublicAddress(cluster).getHostAddress()).destination(jobtracker).ports(new int[]{8021})});
    }

    @Override
    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        InetAddress jobtrackerPublicAddress = HadoopCluster.getJobTrackerPublicAddress(cluster);
        LOG.info("Jobtracker web UI available at http://{}:{}", (Object)jobtrackerPublicAddress.getHostName(), (Object)50030);
    }
}

