/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigurationConverter.class);
    private static final String FINAL_SUFFIX = ".final";

    @VisibleForTesting
    static List<String> asXmlConfigurationLines(Configuration hadoopConfig) {
        ArrayList lines = Lists.newArrayList();
        lines.add("<configuration>");
        Iterator it = hadoopConfig.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.endsWith(FINAL_SUFFIX)) continue;
            String value = StringUtils.join((Object[])hadoopConfig.getStringArray(key), (char)AbstractConfiguration.getDefaultListDelimiter());
            lines.add("  <property>");
            lines.add(String.format("    <name>%s</name>", key));
            lines.add(String.format("    <value>%s</value>", value));
            String finalValue = hadoopConfig.getString(key + FINAL_SUFFIX);
            if (finalValue != null) {
                lines.add(String.format("    <final>%s</final>", finalValue));
            }
            lines.add("  </property>");
        }
        lines.add("</configuration>");
        return lines;
    }

    public static Statement asCreateXmlConfigurationFileStatement(String path, Configuration hadoopConfig) {
        return Statements.createOrOverwriteFile((String)path, HadoopConfigurationConverter.asXmlConfigurationLines(hadoopConfig));
    }

    @VisibleForTesting
    static List<String> asEnvironmentVariablesLines(Configuration hadoopConfig) {
        ArrayList lines = Lists.newArrayList();
        lines.add(". /etc/profile");
        Iterator it = hadoopConfig.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.endsWith(FINAL_SUFFIX)) continue;
            String value = hadoopConfig.getString(key);
            lines.add("export " + key + "=\"" + value + "\"");
        }
        return lines;
    }

    public static Statement asCreateEnvironmentVariablesFileStatement(String path, Configuration config) {
        return Statements.createOrOverwriteFile((String)path, HadoopConfigurationConverter.asEnvironmentVariablesLines(config));
    }

    private static CharSequence generateHadoopConfigurationFile(Properties config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n");
        sb.append("<configuration>\n");
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            sb.append("  <property>\n");
            sb.append("    <name>").append(entry.getKey()).append("</name>\n");
            sb.append("    <value>").append(entry.getValue()).append("</value>\n");
            sb.append("  </property>\n");
        }
        sb.append("</configuration>\n");
        return sb;
    }

    public static void createClientSideHadoopSiteFile(File file, Properties config) {
        try {
            Files.write((CharSequence)HadoopConfigurationConverter.generateHadoopConfigurationFile(config), (File)file, (Charset)Charsets.UTF_8);
            LOG.info("Wrote file {}", (Object)file);
        }
        catch (IOException e) {
            LOG.error("Problem writing file {}", (Object)file, (Object)e);
        }
    }
}

