/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Processor;
import org.jclouds.scriptbuilder.domain.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigurationBuilder.class);
    private static final String WHIRR_HADOOP_DEFAULT_PROPERTIES = "whirr-hadoop-default.properties";

    private static Configuration build(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, String prefix) throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        config.setDelimiterParsingDisabled(true);
        Configuration sub = clusterSpec.getConfigurationForKeysWithPrefix(prefix);
        config.addConfiguration(sub.subset(prefix));
        config.addConfiguration(defaults.subset(prefix));
        return config;
    }

    public static Statement buildCommon(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = HadoopConfigurationBuilder.buildCommonConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HadoopConfigurationBuilder.class.getResource("/whirr-hadoop-default.properties")));
        return HadoopConfigurationConverter.asCreateXmlConfigurationFileStatement(path, config);
    }

    public static Statement buildHdfs(String path, ClusterSpec clusterSpec, Cluster cluster, Set<String> dataDirectories) throws ConfigurationException, IOException {
        Configuration config = HadoopConfigurationBuilder.buildHdfsConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HadoopConfigurationBuilder.class.getResource("/whirr-hadoop-default.properties")), dataDirectories);
        return HadoopConfigurationConverter.asCreateXmlConfigurationFileStatement(path, config);
    }

    public static Statement buildMapReduce(String path, ClusterSpec clusterSpec, Cluster cluster, Set<String> dataDirectories) throws ConfigurationException, IOException {
        Configuration config = HadoopConfigurationBuilder.buildMapReduceConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HadoopConfigurationBuilder.class.getResource("/whirr-hadoop-default.properties")), dataDirectories);
        return HadoopConfigurationConverter.asCreateXmlConfigurationFileStatement(path, config);
    }

    public static Statement buildHadoopEnv(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = HadoopConfigurationBuilder.buildHadoopEnvConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HadoopConfigurationBuilder.class.getResource("/whirr-hadoop-default.properties")));
        return HadoopConfigurationConverter.asCreateEnvironmentVariablesFileStatement(path, config);
    }

    @VisibleForTesting
    static Configuration buildCommonConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException, IOException {
        Configuration config = HadoopConfigurationBuilder.build(clusterSpec, cluster, defaults, "hadoop-common");
        Cluster.Instance namenode = cluster.getInstanceMatching(RolePredicates.role((String)"hadoop-namenode"));
        LOG.debug("hadoop building common configuration, with hostname " + namenode.getPublicHostName());
        config.setProperty("fs.default.name", (Object)String.format("hdfs://%s:8020/", namenode.getPublicHostName()));
        return config;
    }

    @VisibleForTesting
    static Configuration buildHdfsConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, Set<String> dataDirectories) throws ConfigurationException {
        Configuration config = HadoopConfigurationBuilder.build(clusterSpec, cluster, defaults, "hadoop-hdfs");
        HadoopConfigurationBuilder.setIfAbsent(config, "dfs.data.dir", HadoopConfigurationBuilder.appendToDataDirectories(dataDirectories, "/hadoop/hdfs/data"));
        HadoopConfigurationBuilder.setIfAbsent(config, "dfs.name.dir", HadoopConfigurationBuilder.appendToDataDirectories(dataDirectories, "/hadoop/hdfs/name"));
        HadoopConfigurationBuilder.setIfAbsent(config, "fs.checkpoint.dir", HadoopConfigurationBuilder.appendToDataDirectories(dataDirectories, "/hadoop/hdfs/secondary"));
        return config;
    }

    @VisibleForTesting
    static Configuration buildMapReduceConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, Set<String> dataDirectories) throws ConfigurationException, IOException {
        Set jobtracker;
        Hardware hardware;
        Configuration config = HadoopConfigurationBuilder.build(clusterSpec, cluster, defaults, "hadoop-mapreduce");
        HadoopConfigurationBuilder.setIfAbsent(config, "mapred.local.dir", HadoopConfigurationBuilder.appendToDataDirectories(dataDirectories, "/hadoop/mapred/local"));
        Set taskTrackers = cluster.getInstancesMatching(RolePredicates.role((String)"hadoop-tasktracker"));
        if (!taskTrackers.isEmpty() && (hardware = ((Cluster.Instance)Iterables.getFirst((Iterable)taskTrackers, null)).getNodeMetadata().getHardware()) != null) {
            int coresPerNode = 0;
            for (Processor processor : hardware.getProcessors()) {
                coresPerNode = (int)((double)coresPerNode + processor.getCores());
            }
            int mapTasksPerNode = (int)Math.ceil((double)coresPerNode * 1.0);
            int reduceTasksPerNode = (int)Math.ceil((double)coresPerNode * 0.75);
            HadoopConfigurationBuilder.setIfAbsent(config, "mapred.tasktracker.map.tasks.maximum", mapTasksPerNode + "");
            HadoopConfigurationBuilder.setIfAbsent(config, "mapred.tasktracker.reduce.tasks.maximum", reduceTasksPerNode + "");
            int clusterReduceSlots = taskTrackers.size() * reduceTasksPerNode;
            HadoopConfigurationBuilder.setIfAbsent(config, "mapred.reduce.tasks", clusterReduceSlots + "");
        }
        if (!(jobtracker = cluster.getInstancesMatching(RolePredicates.role((String)"hadoop-jobtracker"))).isEmpty()) {
            config.setProperty("mapred.job.tracker", (Object)String.format("%s:8021", ((Cluster.Instance)Iterables.getOnlyElement((Iterable)jobtracker)).getPublicHostName()));
        }
        return config;
    }

    @VisibleForTesting
    static Configuration buildHadoopEnvConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException {
        return HadoopConfigurationBuilder.build(clusterSpec, cluster, defaults, "hadoop-env");
    }

    private static void setIfAbsent(Configuration config, String property, String value) {
        if (!config.containsKey(property)) {
            config.setProperty(property, (Object)value);
        }
    }

    private static String appendToDataDirectories(Set<String> dataDirectories, final String suffix) {
        return Joiner.on((char)',').join((Iterable)Lists.transform((List)Lists.newArrayList(dataDirectories), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input + suffix;
            }
        }));
    }
}

