/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.velocity.app.VelocityEngine;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.hadoop.HadoopConfigurationBuilder;
import org.apache.whirr.service.hadoop.VolumeManager;
import org.apache.whirr.template.TemplateUtils;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopClusterActionHandler
extends ClusterActionHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopClusterActionHandler.class);

    protected Configuration getConfiguration(ClusterSpec clusterSpec) throws IOException {
        return this.getConfiguration(clusterSpec, "whirr-hadoop-default.properties");
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, "hadoop", "install_hadoop");
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, "hadoop", "configure_hadoop");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        String tarball = HadoopClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)conf.getString("whirr.hadoop.tarball.url"));
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf), (String[])new String[]{"-u", tarball}));
    }

    protected Map<String, String> getDeviceMappings(ClusterActionEvent event) {
        Set instances = event.getCluster().getInstancesMatching(RolePredicates.role((String)this.getRole()));
        Cluster.Instance prototype = (Cluster.Instance)Iterables.getFirst((Iterable)instances, null);
        if (prototype == null) {
            throw new IllegalStateException("No instances found in role " + this.getRole());
        }
        VolumeManager volumeManager = new VolumeManager();
        return volumeManager.getDeviceMappings(event.getClusterSpec(), prototype);
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        this.doBeforeConfigure(event);
        this.createHadoopConfigFiles(event, clusterSpec, cluster);
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(this.getConfiguration(clusterSpec)), (String[])new String[]{Joiner.on((String)",").join((Iterable)event.getInstanceTemplate().getRoles()), "-c", clusterSpec.getProvider()}));
    }

    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
    }

    private void createHadoopConfigFiles(ClusterActionEvent event, ClusterSpec clusterSpec, Cluster cluster) throws IOException {
        Map<String, String> deviceMappings = this.getDeviceMappings(event);
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            event.getStatementBuilder().addStatements(new Statement[]{HadoopConfigurationBuilder.buildCommon("/tmp/core-site.xml", clusterSpec, cluster), HadoopConfigurationBuilder.buildHdfs("/tmp/hdfs-site.xml", clusterSpec, cluster, deviceMappings.keySet()), HadoopConfigurationBuilder.buildMapReduce("/tmp/mapred-site.xml", clusterSpec, cluster, deviceMappings.keySet()), HadoopConfigurationBuilder.buildHadoopEnv("/tmp/hadoop-env.sh", clusterSpec, cluster), TemplateUtils.createFileFromTemplate((String)"/tmp/hadoop-metrics.properties", (VelocityEngine)event.getTemplateEngine(), (String)this.getMetricsTemplate(event, clusterSpec, cluster), (ClusterSpec)clusterSpec, (Cluster)cluster)});
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
        String devMappings = VolumeManager.asString(deviceMappings);
        HadoopClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"prepare_all_disks", (String[])new String[]{"'" + devMappings + "'"}));
    }

    private String getMetricsTemplate(ClusterActionEvent event, ClusterSpec clusterSpec, Cluster cluster) {
        Configuration conf = clusterSpec.getConfiguration();
        if (conf.containsKey("hadoop-metrics.template")) {
            return conf.getString("hadoop-metrics.template");
        }
        Set gmetadInstances = cluster.getInstancesMatching(RolePredicates.role((String)"ganglia-metad"));
        if (!gmetadInstances.isEmpty()) {
            return "hadoop-metrics-ganglia.properties.vm";
        }
        return "hadoop-metrics-null.properties.vm";
    }
}

