/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.RolePredicates;

public class HadoopCluster {
    public static final int NAMENODE_PORT = 8020;
    public static final int NAMENODE_WEB_UI_PORT = 50070;
    public static final int JOBTRACKER_PORT = 8021;
    public static final int JOBTRACKER_WEB_UI_PORT = 50030;

    public static InetAddress getNamenodePublicAddress(Cluster cluster) throws IOException {
        return cluster.getInstanceMatching(RolePredicates.role((String)"hadoop-namenode")).getPublicAddress();
    }

    public static InetAddress getNamenodePrivateAddress(Cluster cluster) throws IOException {
        return cluster.getInstanceMatching(RolePredicates.role((String)"hadoop-namenode")).getPrivateAddress();
    }

    private static Cluster.Instance getJobTracker(Cluster cluster) {
        Set jobtracker = cluster.getInstancesMatching(RolePredicates.role((String)"hadoop-jobtracker"));
        if (jobtracker.isEmpty()) {
            return null;
        }
        return (Cluster.Instance)Iterables.getOnlyElement((Iterable)jobtracker);
    }

    public static InetAddress getJobTrackerPublicAddress(Cluster cluster) throws IOException {
        Cluster.Instance jt = HadoopCluster.getJobTracker(cluster);
        return jt == null ? null : jt.getPublicAddress();
    }

    public static InetAddress getJobTrackerPrivateAddress(Cluster cluster) throws IOException {
        Cluster.Instance jt = HadoopCluster.getJobTracker(cluster);
        return jt == null ? null : jt.getPrivateAddress();
    }
}

