/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop.integration.benchmark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import org.apache.commons.lang.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.terasort.TeraGen;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.examples.terasort.TeraValidate;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.whirr.service.hadoop.integration.HadoopServiceController;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopServiceTeraSortBenchmark {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopServiceTeraSortBenchmark.class);
    private static boolean shutdownClusterOnTearDown;
    private static HadoopServiceController controller;

    @BeforeClass
    public static void setUp() throws Exception {
        controller = HadoopServiceController.getInstance("whirr-hadoop-test.properties");
        shutdownClusterOnTearDown = controller.ensureClusterRunning();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (shutdownClusterOnTearDown) {
            controller.shutdown();
        }
    }

    @Test
    public void testTeraSort() throws Exception {
        int runs = Integer.parseInt(System.getProperty("terasortRuns", "3"));
        for (int i = 0; i < runs; ++i) {
            LOG.info("Starting TeraSort run {} of {}", (Object)(i + 1), (Object)runs);
            this.runTeraGen();
            this.runTeraSort();
            this.runTeraValidate();
            FileSystem fs = FileSystem.get((Configuration)controller.getConfiguration());
            FSDataInputStream in = fs.open(new Path("report/part-00000"));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
            String line = null;
            StringBuilder problems = new StringBuilder();
            boolean failed = false;
            while ((line = reader.readLine()) != null) {
                problems.append(line).append("\n");
                failed = true;
            }
            Assert.assertFalse((String)problems.toString(), (boolean)failed);
            reader.close();
            fs.delete(new Path("input"), true);
            fs.delete(new Path("output"), true);
            fs.delete(new Path("report"), true);
            LOG.info("Completed TeraSort run {} of {}", (Object)(i + 1), (Object)runs);
        }
    }

    private void runTeraGen() throws IOException {
        int numTaskTrackers = controller.getCluster().getInstances().size() - 1;
        long bytesPerNode = Long.parseLong(System.getProperty("terasortBytesPerNode", "1000000000"));
        long rows = (long)numTaskTrackers * (bytesPerNode / 100L);
        StopWatch stopWatch = new StopWatch();
        TeraGen teraGen = new TeraGen();
        teraGen.setConf((Configuration)controller.getJobConf());
        LOG.info("Starting TeraGen with {} tasktrackers, {} bytes per node, {} rows", new Object[]{numTaskTrackers, bytesPerNode, rows});
        stopWatch.start();
        teraGen.run(new String[]{"" + rows, "input"});
        stopWatch.stop();
        LOG.info("TeraGen took {} ms", (Object)stopWatch.getTime());
    }

    private void runTeraSort() throws Exception {
        StopWatch stopWatch = new StopWatch();
        TeraSort teraSort = new TeraSort();
        teraSort.setConf((Configuration)controller.getJobConf());
        LOG.info("Starting TeraSort");
        stopWatch.start();
        teraSort.run(new String[]{"input", "output"});
        stopWatch.stop();
        LOG.info("TeraSort took {} ms", (Object)stopWatch.getTime());
    }

    private void runTeraValidate() throws Exception {
        StopWatch stopWatch = new StopWatch();
        TeraValidate teraValidate = new TeraValidate();
        teraValidate.setConf((Configuration)controller.getJobConf());
        LOG.info("Starting TeraValidate");
        stopWatch.start();
        teraValidate.run(new String[]{"output", "report"});
        stopWatch.stop();
        LOG.info("TeraValidate took {} ms", (Object)stopWatch.getTime());
    }
}

