/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop.integration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.hadoop.HadoopProxy;
import org.apache.whirr.service.hadoop.integration.HadoopServiceTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopServiceController.class);
    private static final Map<String, HadoopServiceController> INSTANCES = new HashMap<String, HadoopServiceController>();
    private Configuration configuration;
    private boolean running;
    private ClusterSpec clusterSpec;
    private ClusterController controller;
    private HadoopProxy proxy;
    private Cluster cluster;

    public static HadoopServiceController getInstance(String config) throws ConfigurationException {
        if (!INSTANCES.containsKey(config)) {
            PropertiesConfiguration configuration = new PropertiesConfiguration(config);
            INSTANCES.put(config, new HadoopServiceController((Configuration)configuration));
        }
        return INSTANCES.get(config);
    }

    private HadoopServiceController(Configuration configuration) {
        this.configuration = configuration;
    }

    public synchronized boolean ensureClusterRunning() throws Exception {
        if (this.running) {
            LOG.info("Cluster already running.");
            return false;
        }
        this.startup();
        return true;
    }

    public synchronized void startup() throws Exception {
        LOG.info("Starting up cluster...");
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration(this.configuration);
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterController();
        this.cluster = this.controller.launchCluster(this.clusterSpec);
        this.proxy = new HadoopProxy(this.clusterSpec, this.cluster);
        this.proxy.start();
        org.apache.hadoop.conf.Configuration conf = this.getConfiguration();
        JobConf job = new JobConf(conf, HadoopServiceTest.class);
        JobClient client = new JobClient(job);
        HadoopServiceController.waitToExitSafeMode(client);
        HadoopServiceController.waitForTaskTrackers(client);
        this.running = true;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public org.apache.hadoop.conf.Configuration getConfiguration() {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        for (Map.Entry<Object, Object> entry : this.cluster.getConfiguration().entrySet()) {
            conf.set(entry.getKey().toString(), entry.getValue().toString());
        }
        return conf;
    }

    public JobConf getJobConf() {
        return new JobConf(this.getConfiguration());
    }

    private static void waitToExitSafeMode(JobClient client) throws IOException {
        LOG.info("Waiting to exit safe mode...");
        FileSystem fs = client.getFs();
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        boolean inSafeMode = true;
        while (inSafeMode) {
            inSafeMode = dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET);
            try {
                System.out.print(".");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        LOG.info("Exited safe mode");
    }

    private static void waitForTaskTrackers(JobClient client) throws IOException {
        LOG.info("Waiting for tasktrackers...");
        while (true) {
            ClusterStatus clusterStatus;
            int taskTrackerCount;
            if ((taskTrackerCount = (clusterStatus = client.getClusterStatus()).getTaskTrackers()) > 0) {
                LOG.info("{} tasktrackers reported in. Continuing.", (Object)taskTrackerCount);
                break;
            }
            try {
                System.out.print(".");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public synchronized void shutdown() throws IOException, InterruptedException {
        LOG.info("Shutting down cluster...");
        if (this.proxy != null) {
            this.proxy.stop();
        }
        this.controller.destroyCluster(this.clusterSpec);
        this.running = false;
    }
}

