/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hadoop;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HadoopConfigurationConverterTest {
    @Test
    public void testConversion() {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.setProperty("p1", (Object)"v1,v2");
        conf.setProperty("p2", (Object)"v3");
        List lines = HadoopConfigurationConverter.asXmlConfigurationLines((Configuration)conf);
        Assert.assertThat((Object)lines, (Matcher)Matchers.is((Object)Lists.newArrayList((Object[])new String[]{"<configuration>", "  <property>", "    <name>p1</name>", "    <value>v1,v2</value>", "  </property>", "  <property>", "    <name>p2</name>", "    <value>v3</value>", "  </property>", "</configuration>"})));
    }

    @Test
    public void testFinal() {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.setProperty("p1", (Object)"v1");
        conf.setProperty("p2", (Object)"v2");
        conf.setProperty("p2.final", (Object)"true");
        List lines = HadoopConfigurationConverter.asXmlConfigurationLines((Configuration)conf);
        Assert.assertThat((Object)lines, (Matcher)Matchers.is((Object)Lists.newArrayList((Object[])new String[]{"<configuration>", "  <property>", "    <name>p1</name>", "    <value>v1</value>", "  </property>", "  <property>", "    <name>p2</name>", "    <value>v2</value>", "    <final>true</final>", "  </property>", "</configuration>"})));
    }
}

