/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.ganglia;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.FirewallManager;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaMonitorClusterActionHandler
extends ClusterActionHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GangliaMonitorClusterActionHandler.class);
    public static final String GANGLIA_MONITOR_ROLE = "ganglia-monitor";
    public static final int GANGLIA_MONITOR_PORT = 8649;

    public String getRole() {
        return GANGLIA_MONITOR_ROLE;
    }

    protected Configuration getConfiguration(ClusterSpec spec) throws IOException {
        return this.getConfiguration(spec, "whirr-ganglia-default.properties");
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, this.getRole(), "install_ganglia");
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, this.getRole(), "configure_ganglia");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration config = this.getConfiguration(clusterSpec);
        GangliaMonitorClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        GangliaMonitorClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(config), (String[])new String[]{"-r", GANGLIA_MONITOR_ROLE}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(RolePredicates.role((String)GANGLIA_MONITOR_ROLE)).port(8649));
        Configuration config = this.getConfiguration(clusterSpec);
        String configureFunction = this.getConfigureFunction(config);
        String metadHost = cluster.getInstanceMatching(RolePredicates.role((String)"ganglia-metad")).getPrivateIp();
        GangliaMonitorClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        GangliaMonitorClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)configureFunction, (String[])new String[]{"-m", metadHost}));
    }

    protected void afterConfigure(ClusterActionEvent event) {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {}", (Object)clusterSpec.getClusterName());
        String hosts = Joiner.on((char)',').join(GangliaMonitorClusterActionHandler.getHosts(cluster.getInstancesMatching(RolePredicates.role((String)GANGLIA_MONITOR_ROLE))));
        LOG.info("Monitors: {}", (Object)hosts);
    }

    static List<String> getHosts(Set<Cluster.Instance> instances) {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                try {
                    return instance.getPublicHostName();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }
}

