/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.ganglia.integration;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GangliaServiceTest
extends TestCase {
    private ClusterSpec clusterSpec;
    private Cluster cluster;
    private ClusterController controller;

    @Before
    public void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-ganglia-test.properties"));
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterControllerFactory().create(this.clusterSpec.getServiceName());
        this.cluster = this.controller.launchCluster(this.clusterSpec);
    }

    @Test(timeout=900000L)
    public void test() throws Exception {
        Cluster.Instance metad = this.cluster.getInstanceMatching(RolePredicates.role((String)"ganglia-metad"));
        String metadHostname = metad.getPublicHostName();
        GangliaServiceTest.assertNotNull((Object)metadHostname);
        HttpClient client = new HttpClient();
        GetMethod getIndex = new GetMethod(String.format("http://%s/ganglia/", metadHostname));
        int statusCode = client.executeMethod((HttpMethod)getIndex);
        GangliaServiceTest.assertEquals((String)"Status code should be 200", (int)200, (int)statusCode);
        String indexPageHTML = getIndex.getResponseBodyAsString();
        GangliaServiceTest.assertTrue((String)"The string 'Ganglia' should appear on the index page", (boolean)indexPageHTML.contains("Ganglia"));
        GangliaServiceTest.assertTrue((String)"The string 'WhirrGrid' should appear on the index page", (boolean)indexPageHTML.contains("WhirrGrid"));
        for (Cluster.Instance instance : this.cluster.getInstancesMatching(RolePredicates.anyRoleIn((Set)Sets.newHashSet((Object[])new String[]{"ganglia-metad", "ganglia-monitor"})))) {
            this.testMonitorResponse(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMonitorResponse(Cluster.Instance instance) throws IOException {
        Socket s = null;
        try {
            s = new Socket(instance.getPublicAddress(), 8649);
            String gangliaXml = IOUtils.toString((InputStream)s.getInputStream());
            GangliaServiceTest.assertTrue((String)String.format("The ganglia monitor output on instance %s with roles %s did not contain 'HOST NAME'", instance.getPublicHostName(), instance.getRoles()), (boolean)gangliaXml.contains("HOST NAME"));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.controller.destroyCluster(this.clusterSpec);
    }
}

