/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchConfigurationBuilder.class);
    public static final String ES_PREFIX = "es";

    public static Statement build(String path, Configuration config) {
        return ElasticSearchConfigurationBuilder.asFileStatement(path, config);
    }

    public static Statement build(String path, ClusterSpec spec, Cluster cluster) {
        return ElasticSearchConfigurationBuilder.build(path, ElasticSearchConfigurationBuilder.buildConfig(spec, cluster));
    }

    public static Configuration buildConfig(ClusterSpec spec, Cluster cluster) {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration(spec.getConfiguration());
        try {
            config.addConfiguration((Configuration)new PropertiesConfiguration(ElasticSearchConfigurationBuilder.class.getResource("/whirr-elasticsearch-default.properties")));
        }
        catch (ConfigurationException e) {
            LOG.error("Configuration error", (Throwable)e);
        }
        if ("aws-ec2".equals(spec.getProvider()) || "ec2".equals(spec.getProvider())) {
            ElasticSearchConfigurationBuilder.addDefaultsForEC2(spec, config);
        } else {
            ElasticSearchConfigurationBuilder.addDefaultsForUnicast(cluster, config);
        }
        if (!config.containsKey("es.cluster.name")) {
            config.addProperty("es.cluster.name", (Object)spec.getClusterName());
        }
        return config;
    }

    private static void addDefaultsForEC2(ClusterSpec spec, CompositeConfiguration config) {
        config.addProperty("es.discovery.type", (Object)"ec2");
        if (!config.containsKey("es.cloud.aws.access_key")) {
            config.addProperty("es.cloud.aws.access_key", (Object)spec.getIdentity());
        }
        if (!config.containsKey("es.cloud.aws.secret_key")) {
            config.addProperty("es.cloud.aws.secret_key", (Object)spec.getCredential());
        }
        if (!config.getList("es.plugins", (List)Lists.newLinkedList()).contains("elasticsearch/elasticsearch-cloud-aws/1.5.0")) {
            config.addProperty("es.plugins", (Object)"elasticsearch/elasticsearch-cloud-aws/1.5.0");
        }
    }

    private static void addDefaultsForUnicast(Cluster cluster, CompositeConfiguration config) {
        LinkedList hosts = Lists.newLinkedList();
        for (Cluster.Instance instance : cluster.getInstancesMatching(RolePredicates.role((String)"elasticsearch"))) {
            hosts.add(String.format("\"%s:9300\"", instance.getPrivateIp()));
        }
        config.addProperty("es.discovery.zen.ping.multicast.enabled", (Object)"false");
        config.addProperty("es.discovery.zen.ping.unicast.hosts", (Object)StringUtils.join((Collection)hosts, (String)","));
    }

    private static Statement asFileStatement(String path, Configuration configuration) {
        return Statements.appendFile((String)path, ElasticSearchConfigurationBuilder.asYamlLines(configuration.subset(ES_PREFIX)));
    }

    @VisibleForTesting
    public static List<String> asYamlLines(Configuration config) {
        return ElasticSearchConfigurationBuilder.asYamlLines(config, 0);
    }

    private static List<String> asYamlLines(Configuration config, int depth) {
        ArrayList lines = Lists.newArrayList();
        HashSet prefixes = Sets.newHashSet();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] parts = key.split("\\.");
            String prefix = parts[0];
            if (prefixes.contains(prefix)) continue;
            if (parts.length == 1) {
                lines.add(ElasticSearchConfigurationBuilder.spaces(depth * 2) + key + ": " + config.getProperty(key));
            } else if (parts.length > 1) {
                lines.add(ElasticSearchConfigurationBuilder.spaces(depth * 2) + prefix + ":");
                lines.addAll(ElasticSearchConfigurationBuilder.asYamlLines(config.subset(prefix), depth + 1));
            }
            prefixes.add(prefix);
        }
        return lines;
    }

    private static String spaces(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }
}

