/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.elasticsearch.integration;

import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.elasticsearch.ElasticSearchHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchTest {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchHandler.class);
    private ClusterSpec clusterSpec;
    private ClusterController controller;
    private Cluster cluster;

    @Before
    public void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-elasticsearch-test.properties"));
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterController();
        this.cluster = this.controller.launchCluster(this.clusterSpec);
    }

    @Test(timeout=900000L)
    public void testCheckNumberOfNodes() throws Exception {
        for (int i = 0; i < 20; ++i) {
            int nodes = this.getNumberOfNodes();
            LOG.info("{}/{} nodes joined the elasticsearch cluster", (Object)nodes, (Object)this.cluster.getInstances().size());
            if (nodes == this.cluster.getInstances().size()) {
                return;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new Exception("All nodes did not joined the cluster as expected");
    }

    private int getNumberOfNodes() throws Exception {
        String healthInfo = this.getHealthInfo();
        Pattern nodesPattern = Pattern.compile("\".*number_of_nodes\":(\\d+).*");
        Matcher matcher = nodesPattern.matcher(healthInfo);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    private String getHealthInfo() throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                String line;
                Cluster.Instance instance = (Cluster.Instance)Iterables.get((Iterable)this.cluster.getInstancesMatching(RolePredicates.role((String)"elasticsearch")), (int)0);
                String address = instance.getPublicAddress().getHostAddress();
                URL url = new URL(String.format("http://%s:9200/_cluster/health", address));
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    builder.append(line);
                }
                in.close();
                return builder.toString();
            }
            catch (IOException e) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new Exception("Unable to get cluster health info.");
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.controller.destroyCluster(this.clusterSpec);
    }
}

