/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.elasticsearch;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.elasticsearch.ElasticSearchConfigurationBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ElasticSearchConfigurationBuilderTest {
    @Test
    public void testGenerateYamlConfig() {
        PropertiesConfiguration defaults = new PropertiesConfiguration();
        defaults.addProperty("cloud.aws.id", (Object)"a");
        defaults.addProperty("cloud.aws.key", (Object)"b");
        defaults.addProperty("index.store.type", (Object)"memory");
        String content = StringUtils.join((Collection)ElasticSearchConfigurationBuilder.asYamlLines((Configuration)defaults), (String)"\n");
        MatcherAssert.assertThat((Object)content, (Matcher)org.hamcrest.Matchers.is((Object)"cloud:\n  aws:\n    id: a\n    key: b\nindex:\n  store:\n    type: memory"));
    }

    @Test
    public void testDefaultConfigAwsEC2() throws Exception {
        PropertiesConfiguration baseConfig = new PropertiesConfiguration();
        baseConfig.addProperty("whirr.provider", (Object)"aws-ec2");
        baseConfig.addProperty("es.plugins", (Object)"lang-javascript, lang-python");
        ClusterSpec spec = ClusterSpec.withTemporaryKeys((Configuration)baseConfig);
        Configuration config = ElasticSearchConfigurationBuilder.buildConfig((ClusterSpec)spec, null);
        MatcherAssert.assertThat((Object)config.getStringArray("es.plugins"), (Matcher)org.hamcrest.Matchers.is((Object)new String[]{"lang-javascript", "lang-python", "elasticsearch/elasticsearch-cloud-aws/1.5.0"}));
        MatcherAssert.assertThat((Object)config.getString("es.discovery.type"), (Matcher)org.hamcrest.Matchers.is((Object)"ec2"));
    }

    @Test
    public void testDefaultUnicastConfig() throws Exception {
        PropertiesConfiguration baseConfig = new PropertiesConfiguration();
        baseConfig.addProperty("whirr.provider", (Object)"cloudservers-us");
        ClusterSpec spec = ClusterSpec.withTemporaryKeys((Configuration)baseConfig);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        LinkedHashSet instances = Sets.newLinkedHashSet();
        for (String host : Lists.newArrayList((Object[])new String[]{"10.0.0.1", "10.0.0.2"})) {
            Cluster.Instance instance = (Cluster.Instance)Mockito.mock(Cluster.Instance.class);
            Mockito.when((Object)instance.getPrivateIp()).thenReturn((Object)host);
            instances.add(instance);
        }
        Mockito.when((Object)cluster.getInstancesMatching((Predicate)Matchers.any())).thenReturn((Object)instances);
        Configuration config = ElasticSearchConfigurationBuilder.buildConfig((ClusterSpec)spec, (Cluster)cluster);
        String content = StringUtils.join((Collection)ElasticSearchConfigurationBuilder.asYamlLines((Configuration)config.subset("es")), (String)"\n");
        MatcherAssert.assertThat((Object)content, (Matcher)org.hamcrest.Matchers.is((Object)"index:\n  store:\n    type: memory\ngateway:\n  type: none\ndiscovery:\n  zen:\n    ping:\n      multicast:\n        enabled: false\n      unicast:\n        hosts: [\"10.0.0.1:9300\", \"10.0.0.2:9300\"]"));
    }

    @Test
    public void testOverrideDefaults() throws Exception {
        PropertiesConfiguration baseConfig = new PropertiesConfiguration();
        baseConfig.addProperty("whirr.provider", (Object)"aws-ec2");
        baseConfig.addProperty("es.index.store.type", (Object)"fs");
        ClusterSpec spec = ClusterSpec.withTemporaryKeys((Configuration)baseConfig);
        Configuration config = ElasticSearchConfigurationBuilder.buildConfig((ClusterSpec)spec, null);
        MatcherAssert.assertThat((Object)config.getString("es.index.store.type"), (Matcher)org.hamcrest.Matchers.is((Object)"fs"));
    }
}

