/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.lang.StringUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.command.AbstractClusterCommand;
import org.apache.whirr.state.ClusterStateStoreFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class RunScriptCommand
extends AbstractClusterCommand {
    private OptionSpec<String> rolesOption;
    private OptionSpec<String> instancesOption;
    private OptionSpec<String> scriptOption;

    public RunScriptCommand() {
        this(new ClusterControllerFactory());
    }

    public RunScriptCommand(ClusterControllerFactory factory) {
        this(factory, new ClusterStateStoreFactory());
    }

    public RunScriptCommand(ClusterControllerFactory factory, ClusterStateStoreFactory stateStoreFactory) {
        super("run-script", "Run a script on a specific instance or a group of instances matching a role name", factory, stateStoreFactory);
        this.rolesOption = this.parser.accepts("roles", "List of comma separated role names. E.g. zookeeper,hadoop-namenode").withRequiredArg().ofType(String.class);
        this.instancesOption = this.parser.accepts("instances", "List of comma separated instance IDs").withRequiredArg().ofType(String.class);
        this.scriptOption = this.parser.accepts("script", "Path to script file to execute.").withRequiredArg().ofType(String.class);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[0]));
        if (!optionSet.has(this.scriptOption)) {
            err.println("Please specify a script file to be executed.");
            err.println("Get more help: whirr help " + this.getName());
            return -1;
        }
        if (!new File((String)optionSet.valueOf(this.scriptOption)).exists()) {
            err.printf("Script file '%s' not found.", optionSet.valueOf(this.scriptOption));
            err.println("Get more help: whirr help " + this.getName());
            return -2;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            String[] ids = null;
            String[] roles = null;
            if (optionSet.has(this.instancesOption)) {
                ids = ((String)optionSet.valueOf(this.instancesOption)).split(",");
            }
            if (optionSet.has(this.rolesOption)) {
                roles = ((String)optionSet.valueOf(this.rolesOption)).split(",");
            }
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.run(in, out, err, clusterSpec, ids, roles, (String)optionSet.valueOf(this.scriptOption));
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -3;
        }
    }

    public int run(InputStream in, PrintStream out, PrintStream err, ClusterSpec clusterSpec, String[] instances, String[] roles, String fileName) throws Exception {
        ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
        Predicate<NodeMetadata> condition = this.buildFilterPredicate(instances, roles, clusterSpec);
        return this.handleScriptOutput(out, err, controller.runScriptOnNodesMatching(clusterSpec, condition, this.execFile(fileName)));
    }

    private Predicate<NodeMetadata> buildFilterPredicate(String[] ids, String[] roles, ClusterSpec spec) throws IOException {
        Predicate condition = Predicates.alwaysTrue();
        if (ids != null && ids.length > 0) {
            return Predicates.and((Predicate)condition, (Predicate)NodePredicates.withIds((String[])ids));
        }
        if (roles != null && roles.length > 0) {
            ArrayList instanceIds = Lists.newArrayList();
            Cluster cluster = this.createClusterStateStore(spec).load();
            for (Cluster.Instance instance : cluster.getInstancesMatching(RolePredicates.anyRoleIn((Set)Sets.newHashSet((Object[])roles)))) {
                instanceIds.add(instance.getId());
            }
            condition = Predicates.and((Predicate)condition, (Predicate)NodePredicates.withIds((String[])instanceIds.toArray(new String[0])));
            return condition;
        }
        return condition;
    }

    private int handleScriptOutput(PrintStream out, PrintStream err, Map<? extends NodeMetadata, ExecResponse> responses) {
        int exitStatus = 0;
        for (Map.Entry<? extends NodeMetadata, ExecResponse> entry : responses.entrySet()) {
            out.printf("** Node %s: %s%n", entry.getKey().getId(), Iterables.concat((Iterable)entry.getKey().getPrivateAddresses(), (Iterable)entry.getKey().getPublicAddresses()));
            ExecResponse response = entry.getValue();
            if (response.getExitStatus() != 0) {
                exitStatus = response.getExitStatus();
            }
            out.printf("%s%n", response.getOutput());
            err.printf("%s%n", response.getError());
        }
        return exitStatus;
    }

    private Statement execFile(String filePath) throws IOException {
        return Statements.exec((String)this.getFileContent(filePath));
    }

    private String getFileContent(String filePath) throws IOException {
        return StringUtils.join((Collection)Files.readLines((File)new File(filePath), (Charset)Charset.defaultCharset()), (String)"\n");
    }

    public void printUsage(PrintStream stream) throws IOException {
        stream.println("Usage: whirr run-script [OPTIONS] --script <script> [--instances id1,id2] [--roles role1,role2]");
        stream.println();
        this.parser.printHelpOn((OutputStream)stream);
    }
}

