/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;
import org.apache.whirr.state.ClusterStateStoreFactory;

public abstract class RoleLifecycleCommand
extends AbstractClusterCommand {
    private static final ImmutableSet<String> EMPTYSET = ImmutableSet.of();
    private OptionSpec<String> rolesOption;
    private OptionSpec<String> instanceIdsOption;

    public RoleLifecycleCommand(String name, String description, ClusterControllerFactory factory, ClusterStateStoreFactory stateStoreFactory) {
        super(name, description, factory, stateStoreFactory);
        this.rolesOption = this.parser.accepts("roles", "Cluster roles to target").withRequiredArg().ofType(String.class);
        this.instanceIdsOption = this.parser.accepts("instance-ids", "Cluster instance IDs to target").withRequiredArg().ofType(String.class);
    }

    public abstract int runLifecycleStep(ClusterSpec var1, ClusterController var2, OptionSet var3) throws IOException, InterruptedException;

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.runLifecycleStep(clusterSpec, this.createClusterController(clusterSpec.getServiceName()), optionSet);
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    protected Set<String> getTargetRolesOrEmpty(OptionSet optionSet) {
        if (optionSet.hasArgument(this.rolesOption)) {
            return Sets.newHashSet((Iterable)Splitter.on((String)",").split((CharSequence)optionSet.valueOf(this.rolesOption)));
        }
        return EMPTYSET;
    }

    protected Set<String> getTargetInstanceIdsOrEmpty(OptionSet optionSet) {
        if (optionSet.hasArgument(this.instanceIdsOption)) {
            return Sets.newHashSet((Iterable)Splitter.on((String)",").split((CharSequence)optionSet.valueOf(this.instanceIdsOption)));
        }
        return EMPTYSET;
    }

    public void printUsage(PrintStream stream) throws IOException {
        stream.println("Usage: whirr " + this.getName() + " [OPTIONS] [--roles role1,role2] [--instance-ids id1,id2]");
        stream.println();
        this.parser.printHelpOn((OutputStream)stream);
    }
}

