/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.command.AbstractClusterCommand;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;

public class ListProvidersCommand
extends AbstractClusterCommand {
    Set<String> testedComputeProviders = ImmutableSet.of((Object)"aws-ec2", (Object)"cloudservers-us", (Object)"cloudservers-uk", (Object)"byon");

    public ListProvidersCommand() {
        super("list-providers", "Show a list of the supported providers", new ClusterControllerFactory());
    }

    public ListProvidersCommand(ClusterControllerFactory factory) {
        super("list-providers", "Show a list of the supported providers", factory);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() == 0) {
            this.printUsage(out);
        } else {
            String type = args.get(0);
            if ("compute".equals(type)) {
                this.listComputeProviders(out);
            } else if ("blobstore".equals(type)) {
                this.listBlobstoreProviders(out);
            }
        }
        return 0;
    }

    public void printUsage(PrintStream out) {
        out.println("Usage: whirr list-providers <compute OR blobstore>");
    }

    public void listBlobstoreProviders(Iterable<ProviderMetadata> blobstoreProviders, PrintStream out) {
        for (ProviderMetadata blobstore : blobstoreProviders) {
            out.println("* " + blobstore.getName());
            out.println("\tHomepage: " + blobstore.getHomepage());
            out.println("\tConsole: " + blobstore.getConsole());
            out.println("\tAPI: " + blobstore.getApiMetadata().getDocumentation());
            out.println("\tConfiguration options:");
            out.println("\t\twhirr.blobstore-provider = " + blobstore.getId());
            out.println("\t\twhirr.blobstore-identity = <" + blobstore.getApiMetadata().getIdentityName() + ">");
            out.println("\t\twhirr.blobstore-credential = <" + (String)blobstore.getApiMetadata().getCredentialName().or((Object)"UNUSED") + ">\n");
        }
    }

    public void listBlobstoreApis(Iterable<ApiMetadata> blobstoreApis, PrintStream out) {
        for (ApiMetadata blobstore : blobstoreApis) {
            out.println("* " + blobstore.getName());
            out.println("\tAPI: " + blobstore.getDocumentation());
            out.println("\tConfiguration options:");
            out.println("\t\twhirr.blobstore-provider = " + blobstore.getId());
            out.println("\t\twhirr.blobstore-endpoint = " + blobstore.getEndpointName());
            out.println("\t\twhirr.blobstore-identity = <" + blobstore.getIdentityName() + ">");
            out.println("\t\twhirr.blobstore-credential = <" + (String)blobstore.getCredentialName().or((Object)"UNUSED") + ">\n");
        }
    }

    private void listBlobstoreProviders(PrintStream out) {
        this.listBlobstoreProviders(Providers.viewableAs(BlobStoreContext.class), out);
        this.listBlobstoreApis(Apis.viewableAs(BlobStoreContext.class), out);
    }

    public void listComputeProviders(Iterable<ProviderMetadata> computeProviders, PrintStream out) {
        for (ProviderMetadata provider : computeProviders) {
            if (this.testedComputeProviders.contains(provider.getId())) {
                out.println("* " + provider.getName() + " - tested");
            } else {
                out.println("* " + provider.getName());
            }
            out.println("\tHomepage: " + provider.getHomepage());
            out.println("\tConsole: " + provider.getConsole());
            out.println("\tAPI: " + provider.getApiMetadata().getDocumentation());
            out.println("\tConfiguration options:");
            out.println("\t\twhirr.provider = " + provider.getId());
            out.println("\t\twhirr.identity =  <" + provider.getApiMetadata().getIdentityName() + ">");
            out.println("\t\twhirr.credential = <" + (String)provider.getApiMetadata().getCredentialName().or((Object)"UNUSED") + ">\n");
        }
    }

    public void listComputeApis(Iterable<ApiMetadata> computeApis, PrintStream out) {
        for (ApiMetadata api : computeApis) {
            if (this.testedComputeProviders.contains(api.getId())) {
                out.println("* " + api.getName() + " - tested");
            } else {
                out.println("* " + api.getName());
            }
            out.println("\tAPI: " + api.getDocumentation());
            out.println("\tConfiguration options:");
            out.println("\t\twhirr.provider = " + api.getId());
            out.println("\t\twhirr.endpoint = " + api.getEndpointName());
            out.println("\t\twhirr.identity =  <" + api.getIdentityName() + ">");
            out.println("\t\twhirr.credential = <" + (String)api.getCredentialName().or((Object)"UNUSED") + ">\n");
        }
    }

    private void listComputeProviders(PrintStream out) {
        this.listComputeProviders(Providers.viewableAs(ComputeServiceContext.class), out);
    }
}

