/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;
import org.apache.whirr.state.ClusterStateStore;
import org.apache.whirr.state.ClusterStateStoreFactory;

public class ListClusterCommand
extends AbstractClusterCommand {
    public ListClusterCommand() throws IOException {
        this(new ClusterControllerFactory());
    }

    public ListClusterCommand(ClusterControllerFactory factory) {
        this(factory, new ClusterStateStoreFactory());
    }

    public ListClusterCommand(ClusterControllerFactory factory, ClusterStateStoreFactory stateStoreFactory) {
        super("list-cluster", "List the nodes in a cluster.", factory, stateStoreFactory);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.run(in, out, err, clusterSpec);
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    public int run(InputStream in, PrintStream out, PrintStream err, ClusterSpec clusterSpec) throws Exception {
        ClusterStateStore stateStore = this.createClusterStateStore(clusterSpec);
        ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
        for (Cluster.Instance instance : controller.getInstances(clusterSpec, stateStore)) {
            out.println(Joiner.on((char)'\t').useForNull("-").join((Object)instance.getId(), (Object)instance.getNodeMetadata().getImageId(), new Object[]{instance.getPublicIp(), instance.getPrivateIp(), instance.getNodeMetadata().getState(), instance.getNodeMetadata().getLocation().getId(), Joiner.on((String)",").join((Iterable)instance.getRoles())}));
        }
        return 0;
    }
}

