/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;
import org.apache.whirr.util.Utils;

public class LaunchClusterCommand
extends AbstractClusterCommand {
    public LaunchClusterCommand() throws IOException {
        this(new ClusterControllerFactory());
    }

    public LaunchClusterCommand(ClusterControllerFactory factory) {
        super("launch-cluster", "Launch a new cluster running a service.", factory);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.run(in, out, err, clusterSpec);
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    public int run(InputStream in, PrintStream out, PrintStream err, ClusterSpec clusterSpec) throws Exception {
        ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
        Cluster cluster = controller.launchCluster(clusterSpec);
        out.printf("Started cluster of %s instances\n", cluster.getInstances().size());
        out.println(cluster);
        Utils.printSSHConnectionDetails((PrintStream)out, (ClusterSpec)clusterSpec, (Cluster)cluster, (int)20);
        return 0;
    }
}

