/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.whirr.command.Command;

public class HelpCommand
extends Command {
    public HelpCommand() {
        super("help", "Show help about an action");
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() == 0) {
            this.printUsage(out);
            return -1;
        }
        String helpForCommand = args.get(0);
        ServiceLoader<Command> loader = ServiceLoader.load(Command.class);
        for (Command command : loader) {
            if (!command.getName().equals(helpForCommand)) continue;
            command.printUsage(out);
            return 0;
        }
        err.println("No command found with that name: " + helpForCommand);
        return -2;
    }

    public void printUsage(PrintStream stream) throws IOException {
        stream.println("Usage: whirr help <command>");
    }
}

