/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;

public class DestroyInstanceCommand
extends AbstractClusterCommand {
    private OptionSpec<String> instanceOption;

    public DestroyInstanceCommand() throws IOException {
        this(new ClusterControllerFactory());
    }

    public DestroyInstanceCommand(ClusterControllerFactory factory) {
        super("destroy-instance", "Terminate and cleanup resources for a single instance.", factory);
        this.instanceOption = this.parser.accepts("instance-id", "Cluster instance ID").withRequiredArg().ofType(String.class);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            if (!optionSet.hasArgument(this.instanceOption)) {
                throw new IllegalArgumentException("--instance-id is a mandatory argument");
            }
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            String instanceId = (String)optionSet.valueOf(this.instanceOption);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.run(in, out, err, clusterSpec, instanceId);
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    public int run(InputStream in, PrintStream out, PrintStream err, ClusterSpec clusterSpec, String instanceId) throws Exception {
        ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
        controller.destroyInstance(clusterSpec, instanceId);
        return 0;
    }

    public void printUsage(PrintStream stream) throws IOException {
        stream.println("Usage: whirr destroy-instance --instance-id <region/ID> [OPTIONS]");
        stream.println();
        this.parser.printHelpOn((OutputStream)stream);
    }
}

