/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;

public class DestroyClusterCommand
extends AbstractClusterCommand {
    public DestroyClusterCommand() throws IOException {
        this(new ClusterControllerFactory());
    }

    public DestroyClusterCommand(ClusterControllerFactory factory) {
        super("destroy-cluster", "Terminate and cleanup resources for a running cluster.", factory);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            return this.run(in, out, err, clusterSpec);
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    public int run(InputStream in, PrintStream out, PrintStream err, ClusterSpec clusterSpec) throws Exception {
        ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
        controller.destroyCluster(clusterSpec);
        return 0;
    }
}

