/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.command.AbstractClusterCommand;
import org.apache.whirr.state.ClusterStateStoreFactory;

@Beta
public class CleanupClusterCommand
extends AbstractClusterCommand {
    public CleanupClusterCommand() throws IOException {
        this(new ClusterControllerFactory());
    }

    public CleanupClusterCommand(ClusterControllerFactory factory) {
        this(factory, new ClusterStateStoreFactory());
    }

    public CleanupClusterCommand(ClusterControllerFactory factory, ClusterStateStoreFactory stateStoreFactory) {
        super("cleanup-cluster", "Cleanup the cluster nodes.", factory, stateStoreFactory);
    }

    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionSet optionSet = this.parser.parse(args.toArray(new String[args.size()]));
        if (!optionSet.nonOptionArguments().isEmpty()) {
            this.printUsage(err);
            return -1;
        }
        try {
            ClusterSpec clusterSpec = this.getClusterSpec(optionSet);
            this.printProviderInfo(out, err, clusterSpec, optionSet);
            ClusterController controller = this.createClusterController(clusterSpec.getServiceName());
            controller.cleanupCluster(clusterSpec);
            return 0;
        }
        catch (IllegalArgumentException e) {
            this.printErrorAndHelpHint(err, e);
            return -1;
        }
    }

    public void printUsage(PrintStream stream) throws IOException {
        stream.println("Usage: whirr cleanup-cluster [OPTIONS]");
        stream.println();
        this.parser.printHelpOn((OutputStream)stream);
    }
}

