/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.whirr.command.Command;
import org.apache.whirr.service.ClusterActionHandler;

public class Main {
    private Map<String, Command> commandMap = Maps.newLinkedHashMap();
    private int maxLen = 0;

    Main(Command ... commands) throws IOException {
        this(Lists.newArrayList((Object[])commands));
    }

    Main(Iterable<Command> commands) throws IOException {
        for (Command command : commands) {
            this.commandMap.put(command.getName(), command);
            this.maxLen = Math.max(this.maxLen, command.getName().length());
        }
    }

    int run(InputStream in, PrintStream out, PrintStream err, List<String> list) throws Exception {
        if (list.isEmpty()) {
            this.printUsage(out);
            return -1;
        }
        Command command = this.commandMap.get(list.get(0));
        if (command == null) {
            err.printf("Unrecognized command '%s'\n", list.get(0));
            err.println();
            this.printUsage(err);
            return -1;
        }
        return command.run(in, out, err, list.subList(1, list.size()));
    }

    private void printUsage(PrintStream stream) {
        stream.println("Usage: whirr COMMAND [ARGS]");
        stream.println("where COMMAND may be one of:");
        stream.println();
        for (Command command : this.commandMap.values()) {
            stream.printf("%" + this.maxLen + "s  %s\n", command.getName(), command.getDescription());
        }
        stream.println();
        stream.println("Available roles for instances:");
        for (String roleName : Main.getSortedRoleNames()) {
            stream.println("  " + roleName);
        }
    }

    private static SortedSet<String> getSortedRoleNames() {
        ServiceLoader<ClusterActionHandler> loader = ServiceLoader.load(ClusterActionHandler.class);
        TreeSet roles = Sets.newTreeSet();
        for (ClusterActionHandler handler : loader) {
            roles.add(handler.getRole());
        }
        return roles;
    }

    public static void main(String ... args) throws Exception {
        ServiceLoader<Command> loader = ServiceLoader.load(Command.class);
        Main main = new Main(loader);
        int rc = main.run(System.in, System.out, System.err, Arrays.asList(args));
        System.exit(rc);
    }
}

