/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.cli.command.BaseCommandTest;
import org.apache.whirr.cli.command.RunScriptCommand;
import org.apache.whirr.state.ClusterStateStoreFactory;
import org.apache.whirr.state.MemoryClusterStateStore;
import org.apache.whirr.util.KeyPair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.scriptbuilder.domain.Statement;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class RunScriptCommandTest
extends BaseCommandTest {
    @Test
    public void testScriptPathIsMandatory() throws Exception {
        RunScriptCommand command = new RunScriptCommand();
        int rc = command.run(null, this.out, this.err, (List)Lists.newArrayList());
        MatcherAssert.assertThat((Object)rc, (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)this.errBytes.toString(), (Matcher)Matchers.containsString((String)"Please specify a script file to be executed."));
    }

    @Test
    public void testRunScriptByInstanceId() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)factory.create((String)org.mockito.Matchers.any())).thenReturn((Object)controller);
        RunScriptCommand command = new RunScriptCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, System.err, (List)Lists.newArrayList((Object[])new String[]{"--script", "/dev/null", "--instance-templates", "1 noop", "--instances", "A,B", "--cluster-name", "test-cluster", "--provider", "provider", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        MatcherAssert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        ArgumentCaptor predicate = ArgumentCaptor.forClass(Predicate.class);
        ((ClusterController)Mockito.verify((Object)controller)).runScriptOnNodesMatching((ClusterSpec)org.mockito.Matchers.any(), (Predicate)predicate.capture(), (Statement)org.mockito.Matchers.any());
        Predicate expected = Predicates.and((Predicate)Predicates.alwaysTrue(), (Predicate)NodePredicates.withIds((String[])new String[]{"A", "B"}));
        MatcherAssert.assertThat((Object)((Predicate)predicate.getValue()).toString(), (Matcher)Matchers.is((Object)expected.toString()));
    }

    @Test
    public void testRunScriptByRole() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)factory.create((String)org.mockito.Matchers.any())).thenReturn((Object)controller);
        MemoryClusterStateStore memStore = new MemoryClusterStateStore();
        memStore.save(this.createTestCluster(new String[]{"reg/A", "reg/B"}, new String[]{"A", "B"}));
        ClusterStateStoreFactory stateStoreFactory = (ClusterStateStoreFactory)Mockito.mock(ClusterStateStoreFactory.class);
        Mockito.when((Object)stateStoreFactory.create((ClusterSpec)org.mockito.Matchers.any())).thenReturn((Object)memStore);
        RunScriptCommand command = new RunScriptCommand(factory, stateStoreFactory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, System.err, (List)Lists.newArrayList((Object[])new String[]{"--instance-templates", "1 noop", "--script", "/dev/null", "--roles", "A", "--cluster-name", "test-cluster", "--provider", "provider", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        MatcherAssert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        ArgumentCaptor predicate = ArgumentCaptor.forClass(Predicate.class);
        ((ClusterController)Mockito.verify((Object)controller)).runScriptOnNodesMatching((ClusterSpec)org.mockito.Matchers.any(), (Predicate)predicate.capture(), (Statement)org.mockito.Matchers.any());
        Predicate expected = Predicates.and((Predicate)Predicates.alwaysTrue(), (Predicate)NodePredicates.withIds((String[])new String[]{"reg/A"}));
        MatcherAssert.assertThat((Object)((Predicate)predicate.getValue()).toString(), (Matcher)Matchers.is((Object)expected.toString()));
    }

    private Cluster createTestCluster(String[] ids, String[] roles) {
        Preconditions.checkArgument((ids.length == roles.length ? 1 : 0) != 0, (Object)"each ID should have a role");
        Credentials credentials = new Credentials("dummy", "dummy");
        HashSet instances = Sets.newHashSet();
        for (int i = 0; i < ids.length; ++i) {
            String ip = "127.0.0." + (i + 1);
            instances.add(new Cluster.Instance(credentials, (Set)Sets.newHashSet((Object[])new String[]{roles[i]}), ip, ip, ids[i], null));
        }
        return new Cluster((Set)instances);
    }
}

