/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.cli.command.BaseCommandTest;
import org.apache.whirr.cli.command.ListClusterCommand;
import org.apache.whirr.state.ClusterStateStore;
import org.apache.whirr.state.ClusterStateStoreFactory;
import org.apache.whirr.state.MemoryClusterStateStore;
import org.apache.whirr.util.KeyPair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ListClusterCommandTest
extends BaseCommandTest {
    @Test
    public void testInsufficientOptions() throws Exception {
        ListClusterCommand command = new ListClusterCommand();
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, null, this.err, (List)Lists.newArrayList((Object[])new String[]{"--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)this.errBytes.toString(), (Matcher)Matchers.containsString((String)"Option 'cluster-name' not set."));
    }

    @Test
    public void testAllOptions() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)factory.create((String)org.mockito.Matchers.any())).thenReturn((Object)controller);
        NodeMetadata node1 = new NodeMetadataBuilder().name("name1").ids("id1").location(new LocationBuilder().scope(LocationScope.PROVIDER).id("location-id1").description("location-desc1").build()).imageId("image-id").state(NodeState.RUNNING).publicAddresses((Iterable)Lists.newArrayList((Object[])new String[]{"127.0.0.1"})).privateAddresses((Iterable)Lists.newArrayList((Object[])new String[]{"127.0.0.1"})).build();
        NodeMetadata node2 = new NodeMetadataBuilder().name("name2").ids("id2").location(new LocationBuilder().scope(LocationScope.PROVIDER).id("location-id2").description("location-desc2").build()).imageId("image-id").state(NodeState.RUNNING).publicAddresses((Iterable)Lists.newArrayList((Object[])new String[]{"127.0.0.2"})).privateAddresses((Iterable)Lists.newArrayList((Object[])new String[]{"127.0.0.2"})).build();
        Mockito.when((Object)controller.getNodes((ClusterSpec)org.mockito.Matchers.any())).thenReturn((Object)Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new NodeMetadata[]{node1, node2})));
        Mockito.when((Object)controller.getInstances((ClusterSpec)org.mockito.Matchers.any(), (ClusterStateStore)org.mockito.Matchers.any())).thenCallRealMethod();
        MemoryClusterStateStore memStore = new MemoryClusterStateStore();
        memStore.save(this.createTestCluster(new String[]{"id1", "id2"}, new String[]{"role1", "role2"}));
        ClusterStateStoreFactory stateStoreFactory = (ClusterStateStoreFactory)Mockito.mock(ClusterStateStoreFactory.class);
        Mockito.when((Object)stateStoreFactory.create((ClusterSpec)org.mockito.Matchers.any())).thenReturn((Object)memStore);
        ListClusterCommand command = new ListClusterCommand(factory, stateStoreFactory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, null, (List)Lists.newArrayList((Object[])new String[]{"--instance-templates", "1 noop", "--service-name", "test-service", "--cluster-name", "test-cluster", "--identity", "myusername", "--quiet", "--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)this.outBytes.toString(), (Matcher)Matchers.is((Object)"id1\timage-id\t127.0.0.1\t127.0.0.1\tRUNNING\tlocation-id1\trole1\nid2\timage-id\t127.0.0.2\t127.0.0.2\tRUNNING\tlocation-id2\trole2\n"));
        ((ClusterControllerFactory)Mockito.verify((Object)factory)).create("test-service");
    }

    private Cluster createTestCluster(String[] ids, String[] roles) {
        Preconditions.checkArgument((ids.length == roles.length ? 1 : 0) != 0, (Object)"each ID should have a role");
        Credentials credentials = new Credentials("dummy", "dummy");
        HashSet instances = Sets.newHashSet();
        for (int i = 0; i < ids.length; ++i) {
            String ip = "127.0.0." + (i + 1);
            instances.add(new Cluster.Instance(credentials, (Set)Sets.newHashSet((Object[])new String[]{roles[i]}), ip, ip, ids[i], null));
        }
        return new Cluster((Set)instances);
    }
}

