/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.InstanceTemplate;
import org.apache.whirr.cli.command.BaseCommandTest;
import org.apache.whirr.cli.command.LaunchClusterCommand;
import org.apache.whirr.service.DryRunModule;
import org.apache.whirr.util.KeyPair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jclouds.compute.ComputeServiceContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LaunchClusterCommandTest
extends BaseCommandTest {
    @Test
    public void testInsufficientArgs() throws Exception {
        LaunchClusterCommand command = new LaunchClusterCommand();
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, null, this.err, (List)Lists.newArrayList((Object[])new String[]{"--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)this.errBytes.toString(), (Matcher)Matchers.containsString((String)"Option 'cluster-name' not set."));
    }

    @Test
    public void testAllOptions() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)factory.create((String)org.mockito.Matchers.any())).thenReturn((Object)controller);
        Mockito.when((Object)controller.launchCluster((ClusterSpec)org.mockito.Matchers.any())).thenReturn((Object)cluster);
        LaunchClusterCommand command = new LaunchClusterCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, null, (List)Lists.newArrayList((Object[])new String[]{"--service-name", "test-service", "--cluster-name", "test-cluster", "--instance-templates", "1 role1+role2,2 role3", "--provider", "rackspace", "--endpoint", "http://endpoint", "--blobstore-endpoint", "http://blobstore-endpoint", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath(), "--version", "version-string"}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.addProperty("whirr.version", (Object)"version-string");
        ClusterSpec expectedClusterSpec = ClusterSpec.withTemporaryKeys((Configuration)conf);
        expectedClusterSpec.setInstanceTemplates((List)Lists.newArrayList((Object[])new InstanceTemplate[]{InstanceTemplate.builder().numberOfInstance(1).roles(new String[]{"role1", "role2"}).build(), InstanceTemplate.builder().numberOfInstance(2).roles(new String[]{"role3"}).build()}));
        expectedClusterSpec.setServiceName("test-service");
        expectedClusterSpec.setProvider("rackspace");
        expectedClusterSpec.setEndpoint("http://endpoint");
        expectedClusterSpec.setIdentity("myusername");
        expectedClusterSpec.setCredential("mypassword");
        expectedClusterSpec.setBlobStoreEndpoint("http://blobstore-endpoint");
        expectedClusterSpec.setClusterName("test-cluster");
        expectedClusterSpec.setPrivateKey((File)keys.get("private"));
        expectedClusterSpec.setPublicKey((File)keys.get("public"));
        ((ClusterControllerFactory)Mockito.verify((Object)factory)).create("test-service");
        ((ClusterController)Mockito.verify((Object)controller)).launchCluster(expectedClusterSpec);
        Assert.assertThat((Object)this.outBytes.toString(), (Matcher)Matchers.containsString((String)"Started cluster of 0 instances"));
    }

    @Test
    public void testMaxPercentFailure() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)factory.create((String)org.mockito.Matchers.any())).thenReturn((Object)controller);
        Mockito.when((Object)controller.launchCluster((ClusterSpec)org.mockito.Matchers.any())).thenReturn((Object)cluster);
        LaunchClusterCommand command = new LaunchClusterCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, null, (List)Lists.newArrayList((Object[])new String[]{"--service-name", "hadoop", "--cluster-name", "test-cluster", "--instance-templates", "1 hadoop-namenode+hadoop-jobtracker,3 hadoop-datanode+hadoop-tasktracker", "--instance-templates-max-percent-failures", "60 hadoop-datanode+hadoop-tasktracker", "--provider", "aws-ec2", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath(), "--version", "version-string"}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.addProperty("whirr.provider", (Object)"aws-ec2");
        conf.addProperty("whirr.version", (Object)"version-string");
        conf.addProperty("whirr.instance-templates-max-percent-failure", (Object)"60 hadoop-datanode+hadoop-tasktracker");
        ClusterSpec expectedClusterSpec = ClusterSpec.withTemporaryKeys((Configuration)conf);
        expectedClusterSpec.setInstanceTemplates((List)Lists.newArrayList((Object[])new InstanceTemplate[]{InstanceTemplate.builder().numberOfInstance(1).minNumberOfInstances(1).roles(new String[]{"hadoop-namenode", "hadoop-jobtracker"}).build(), InstanceTemplate.builder().numberOfInstance(3).minNumberOfInstances(2).roles(new String[]{"hadoop-datanode", "hadoop-tasktracker"}).build()}));
        expectedClusterSpec.setServiceName("hadoop");
        expectedClusterSpec.setIdentity("myusername");
        expectedClusterSpec.setCredential("mypassword");
        expectedClusterSpec.setClusterName("test-cluster");
        expectedClusterSpec.setPrivateKey((File)keys.get("private"));
        expectedClusterSpec.setPublicKey((File)keys.get("public"));
        ((ClusterControllerFactory)Mockito.verify((Object)factory)).create("hadoop");
        ((ClusterController)Mockito.verify((Object)controller)).launchCluster(expectedClusterSpec);
        Assert.assertThat((Object)this.outBytes.toString(), (Matcher)Matchers.containsString((String)"Started cluster of 0 instances"));
    }

    @Test
    public void testLaunchClusterUsingDryRun() throws Exception {
        ClusterControllerFactory factory = new ClusterControllerFactory();
        TestLaunchClusterCommand launchCluster = new TestLaunchClusterCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = launchCluster.run(null, this.out, this.err, Lists.newArrayList((Object[])new String[]{"--cluster-name", "test-cluster-launch", "--state-store", "none", "--instance-templates", "1 zookeeper+cassandra, 1 zookeeper+elasticsearch", "--provider", "stub", "--identity", "dummy", "--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        MatcherAssert.assertThat((Object)rc, (Matcher)Matchers.is((Object)0));
        this.assertExecutedPhases(launchCluster.dryRun, "bootstrap", "configure", "start");
    }

    static class TestLaunchClusterCommand
    extends LaunchClusterCommand {
        private ClusterSpec clusterSpec;
        private DryRunModule.DryRun dryRun;

        public TestLaunchClusterCommand(ClusterControllerFactory factory) {
            super(factory);
        }

        protected ClusterSpec getClusterSpec(OptionSet optionSet) throws ConfigurationException {
            this.clusterSpec = super.getClusterSpec(optionSet);
            return this.clusterSpec;
        }

        protected ClusterController createClusterController(String serviceName) {
            ClusterController controller = super.createClusterController(serviceName);
            this.dryRun = ((DryRunModule.DryRun)((ComputeServiceContext)controller.getCompute().apply((Object)this.clusterSpec)).utils().injector().getInstance(DryRunModule.DryRun.class)).reset();
            return controller;
        }
    }
}

