/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.cli.command.BaseCommandTest;
import org.apache.whirr.cli.command.DestroyInstanceCommand;
import org.apache.whirr.util.KeyPair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DestroyInstanceCommandTest
extends BaseCommandTest {
    @Test
    public void testInstanceIdMandatory() throws Exception {
        DestroyInstanceCommand command = new DestroyInstanceCommand();
        int rc = command.run(null, this.out, this.err, Collections.emptyList());
        MatcherAssert.assertThat((Object)rc, (Matcher)org.hamcrest.Matchers.is((Object)-1));
        String errOutput = this.errBytes.toString();
        MatcherAssert.assertThat((Object)errOutput, (Matcher)org.hamcrest.Matchers.containsString((String)"--instance-id is a mandatory argument"));
    }

    @Test
    public void testDestroyInstanceById() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)factory.create((String)Matchers.any())).thenReturn((Object)controller);
        DestroyInstanceCommand command = new DestroyInstanceCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, null, (List)Lists.newArrayList((Object[])new String[]{"--instance-templates", "1 noop", "--instance-id", "region/instanceid", "--service-name", "test-service", "--cluster-name", "test-cluster", "--provider", "rackspace", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath(), "--version", "version-string"}));
        MatcherAssert.assertThat((Object)rc, (Matcher)org.hamcrest.Matchers.is((Object)0));
        ((ClusterController)Mockito.verify((Object)controller)).destroyInstance((ClusterSpec)Matchers.any(), (String)Matchers.eq((Object)"region/instanceid"));
    }
}

