/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.cli.command.BaseCommandTest;
import org.apache.whirr.cli.command.DestroyClusterCommand;
import org.apache.whirr.util.KeyPair;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DestroyClusterCommandTest
extends BaseCommandTest {
    @Test
    public void testInsufficientOptions() throws Exception {
        DestroyClusterCommand command = new DestroyClusterCommand();
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, null, this.err, (List)Lists.newArrayList((Object[])new String[]{"--private-key-file", ((File)keys.get("private")).getAbsolutePath()}));
        Assert.assertThat((Object)rc, (Matcher)org.hamcrest.Matchers.is((Object)-1));
        Assert.assertThat((Object)this.errBytes.toString(), (Matcher)org.hamcrest.Matchers.containsString((String)"Option 'cluster-name' not set"));
    }

    @Test
    public void testAllOptions() throws Exception {
        ClusterControllerFactory factory = (ClusterControllerFactory)Mockito.mock(ClusterControllerFactory.class);
        ClusterController controller = (ClusterController)Mockito.mock(ClusterController.class);
        Mockito.when((Object)factory.create((String)Matchers.any())).thenReturn((Object)controller);
        DestroyClusterCommand command = new DestroyClusterCommand(factory);
        Map keys = KeyPair.generateTemporaryFiles();
        int rc = command.run(null, this.out, null, (List)Lists.newArrayList((Object[])new String[]{"--instance-templates", "1 noop", "--service-name", "test-service", "--cluster-name", "test-cluster", "--provider", "rackspace", "--identity", "myusername", "--credential", "mypassword", "--private-key-file", ((File)keys.get("private")).getAbsolutePath(), "--version", "version-string"}));
        Assert.assertThat((Object)rc, (Matcher)org.hamcrest.Matchers.is((Object)0));
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.addProperty("whirr.version", (Object)"version-string");
        conf.addProperty("whirr.instance-templates", (Object)"1 noop");
        ClusterSpec expectedClusterSpec = ClusterSpec.withTemporaryKeys((Configuration)conf);
        expectedClusterSpec.setServiceName("test-service");
        expectedClusterSpec.setProvider("rackspace");
        expectedClusterSpec.setIdentity("myusername");
        expectedClusterSpec.setCredential("mypassword");
        expectedClusterSpec.setClusterName("test-cluster");
        expectedClusterSpec.setPrivateKey((File)keys.get("private"));
        expectedClusterSpec.setPublicKey((File)keys.get("public"));
        ((ClusterControllerFactory)Mockito.verify((Object)factory)).create("test-service");
        ((ClusterController)Mockito.verify((Object)controller)).destroyCluster(expectedClusterSpec);
    }
}

