/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli.command;

import com.google.common.collect.ListMultimap;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import junit.framework.Assert;
import org.apache.whirr.service.DryRunModule;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.junit.Before;

public class BaseCommandTest {
    protected ByteArrayOutputStream outBytes;
    protected PrintStream out;
    protected ByteArrayOutputStream errBytes;
    protected PrintStream err;

    @Before
    public void setUp() {
        this.outBytes = new ByteArrayOutputStream();
        this.out = new PrintStream(this.outBytes);
        this.errBytes = new ByteArrayOutputStream();
        this.err = new PrintStream(this.errBytes);
    }

    protected void assertNoEntryForPhases(DryRunModule.DryRun dryRun, String ... phases) throws Exception {
        for (String phaseName : phases) {
            try {
                Assert.fail((String)("Found entry: " + this.getEntryForPhase((ListMultimap<NodeMetadata, Statement>)dryRun.getExecutions(), phaseName) + " for phase: " + phaseName));
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    protected void assertExecutedPhases(DryRunModule.DryRun dryRun, String ... phases) throws Exception {
        for (String phaseName : phases) {
            try {
                this.getEntryForPhase((ListMultimap<NodeMetadata, Statement>)dryRun.getExecutions(), phaseName);
            }
            catch (IllegalStateException e) {
                Assert.fail((String)("No entry found for phase: " + phaseName));
            }
        }
    }

    private Map.Entry<NodeMetadata, Statement> getEntryForPhase(ListMultimap<NodeMetadata, Statement> executions, String phaseName) throws Exception {
        for (Map.Entry entry : executions.entries()) {
            if (!this.getScriptName((Statement)entry.getValue()).startsWith(phaseName)) continue;
            return entry;
        }
        throw new IllegalStateException("phase not found: " + phaseName);
    }

    private String getScriptName(Statement script) throws Exception {
        return ((InitScript)InitScript.class.cast(script)).getInstanceName();
    }
}

