/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.cli;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.apache.whirr.cli.Main;
import org.apache.whirr.command.Command;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MainTest {
    @Test
    public void testNoArgs() throws Exception {
        Main main = new Main(new Command[]{new TestCommand()});
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        int rc = main.run(null, out, null, Collections.emptyList());
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)bytes.toString(), (Matcher)Matchers.containsString((String)"Usage: whirr COMMAND"));
        Assert.assertThat((Object)bytes.toString(), (Matcher)Matchers.containsString((String)"test-command  test description"));
    }

    @Test
    public void testUnrecognizedCommand() throws Exception {
        Main main = new Main(new Command[]{new TestCommand()});
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(bytes);
        int rc = main.run(null, null, err, (List)Lists.newArrayList((Object[])new String[]{"bogus-command"}));
        Assert.assertThat((Object)rc, (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)bytes.toString(), (Matcher)Matchers.containsString((String)"Unrecognized command 'bogus-command'"));
    }

    @Test
    public void testCommand() throws Exception {
        Command command = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)command.getName()).thenReturn((Object)"mock-command");
        Main main = new Main(new Command[]{command});
        main.run(null, null, null, (List)Lists.newArrayList((Object[])new String[]{"mock-command", "arg1", "arg2"}));
        ((Command)Mockito.verify((Object)command)).run(null, null, null, (List)Lists.newArrayList((Object[])new String[]{"arg1", "arg2"}));
    }

    static class TestCommand
    extends Command {
        public TestCommand() {
            super("test-command", "test description");
        }

        public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
            return 0;
        }

        public void printUsage(PrintStream stream) throws IOException {
        }
    }
}

