/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.chef;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class Recipe
implements Statement {
    public final String cookbook;
    public final String recipe;
    public String url;
    public final Map<String, Object> attribs = new LinkedHashMap<String, Object>();
    @VisibleForTesting
    String fileName = null;

    public Recipe(String cookbook) {
        this(cookbook, null);
    }

    public Recipe(String cookbook, String recipe) {
        this.cookbook = cookbook;
        this.recipe = recipe;
        this.fileName = cookbook + "::" + (recipe != null ? recipe : "default") + "-" + System.currentTimeMillis();
    }

    public Recipe(String cookbook, String recipe, String url) {
        this(cookbook, recipe);
        this.url = url;
    }

    Recipe(String cookbook, String recipe, Configuration config) {
        this(cookbook, recipe);
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String attribute = key.substring(cookbook.length() + 1, key.length());
            if (attribute.equals("url")) {
                this.url = config.getString(key);
                continue;
            }
            this.attribs.put(attribute, config.getProperty(key));
        }
    }

    public String toJSON() {
        Gson gson = new Gson();
        JsonObject recipeAsJSON = new JsonObject();
        if (!this.attribs.isEmpty()) {
            JsonObject jsonAttribs = new JsonObject();
            for (Map.Entry<String, Object> entry : this.attribs.entrySet()) {
                jsonAttribs.add(entry.getKey(), gson.toJsonTree(entry.getValue()));
            }
            recipeAsJSON.add(this.cookbook, (JsonElement)jsonAttribs);
        }
        recipeAsJSON.add("run_list", gson.toJsonTree((Object)new String[]{"recipe[" + this.cookbook + (this.recipe != null ? "::" + this.recipe : "") + "]"}));
        return gson.toJson((JsonElement)recipeAsJSON);
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    public String render(OsFamily family) {
        if (family.equals((Object)OsFamily.UNIX)) {
            String fileName = "/tmp/" + this.fileName + ".json";
            Statement storeJSonFile = Statements.createOrOverwriteFile((String)fileName, Collections.singleton(this.toJSON()));
            Statement runRecipe = null;
            runRecipe = Statements.exec((String)("sudo -i chef-solo -j " + fileName + (this.url != null ? " -r " + this.url : "")));
            return Statements.newStatementList((Statement[])new Statement[]{storeJSonFile, runRecipe}).render(family);
        }
        throw new UnsupportedOperationException();
    }

    public static RunScriptOptions recipeScriptOptions(RunScriptOptions options) {
        return options.wrapInInitScript(true).runAsRoot(true);
    }
}

