/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.chef;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.chef.Recipe;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class ChefClusterActionHandler
extends ClusterActionHandlerSupport {
    public static final String CHEF_SLEEP_AFTER_RECIPE = "whirr.chef.recipe.sleep";
    public static final long CHEF_SLEEP_AFTER_RECIPE_DEFAULT = 2000L;
    private String role;
    private String cookbook;
    private String recipe;
    private long sleepAfterConfigure;

    public ChefClusterActionHandler(String role) {
        this.role = role;
        this.parseCookbookAndRecipe();
    }

    public String getRole() {
        return this.role;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException, InterruptedException {
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        if (ChefClusterActionHandler.isFirstChefRoleIn(event.getInstanceTemplate().getRoles()).apply((Object)this.role)) {
            this.addInstallChefStatements(event);
            this.sleepAfterConfigure = event.getClusterSpec().getConfiguration().getLong(CHEF_SLEEP_AFTER_RECIPE, 2000L);
        }
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        if (this.role.equals("")) {
            return;
        }
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)new Recipe(this.cookbook, this.recipe, event.getClusterSpec().getConfigurationForKeysWithPrefix(this.cookbook)));
    }

    private void addInstallChefStatements(ClusterActionEvent event) {
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_ruby", (String[])new String[0]));
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_git", (String[])new String[0]));
        ChefClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_chef", (String[])new String[0]));
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        Thread.sleep(this.sleepAfterConfigure);
    }

    private void parseCookbookAndRecipe() {
        String[] both = this.role.trim().split(":");
        if (both.length < 1 || both.length > 3) {
            throw new IllegalArgumentException("Chef roles must be specified the following way: \"chef\" to install chef with no recipes, \"chef:cookbook_name\" to install the default recipe in the provided cookbook, or \"chef:cookbook_name:recipe_name\" to  install a particular recipe [was: " + this.role + "]");
        }
        switch (both.length) {
            case 3: {
                this.recipe = both[2];
            }
            case 2: {
                this.cookbook = both[1];
            }
        }
    }

    private static Predicate<String> isFirstChefRoleIn(final Iterable<String> roles) {
        return new Predicate<String>(){

            public boolean apply(String arg0) {
                return ((String)Iterables.get((Iterable)Iterables.filter((Iterable)roles, (Predicate)Predicates.containsPattern((String)("^chef" + arg0))), (int)0)).equals("chef" + arg0);
            }

            public String toString() {
                return "isFirstChefRoleIn(" + roles + ")";
            }
        };
    }
}

