/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.chef.integration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.chef.Recipe;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChefServiceTest {
    private static Predicate<NodeMetadata> allNodes = Predicates.alwaysTrue();
    private static final Logger LOG = LoggerFactory.getLogger(ChefServiceTest.class);
    private static ClusterSpec clusterSpec;
    private static ClusterController controller;

    @BeforeClass
    public static void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-chef-test.properties"));
        clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        controller = new ClusterController();
        controller.launchCluster(clusterSpec);
    }

    @Test(timeout=900000L)
    public void testRecipesWereRanInServiceBootstrap() throws Exception {
        Statement testAnt = Statements.exec((String)"ant -version");
        Map responses = controller.runScriptOnNodesMatching(clusterSpec, allNodes, testAnt);
        ChefServiceTest.printResponses(testAnt, responses);
        ChefServiceTest.assertResponsesContain(responses, testAnt, "Apache Ant");
        Statement testMaven = Statements.exec((String)"mvn --version");
        responses = controller.runScriptOnNodesMatching(clusterSpec, allNodes, testMaven);
        ChefServiceTest.printResponses(testMaven, responses);
        ChefServiceTest.assertResponsesContain(responses, testMaven, "Apache Maven");
    }

    @Test(timeout=900000L)
    public void testChefRunRecipeFromURL() throws Exception {
        Recipe nginx = new Recipe("nginx", null, "http://s3.amazonaws.com/opscode-community/cookbook_versions/tarballs/529/original/nginx.tgz");
        Map<? extends NodeMetadata, ExecResponse> responses = this.runRecipe(nginx);
        ChefServiceTest.printResponses((Statement)nginx, responses);
        HttpClient client = new HttpClient();
        final GetMethod getIndex = new GetMethod(String.format("http://%s", responses.keySet().iterator().next().getPublicAddresses().iterator().next()));
        Assert.assertTrue((String)"Could not connect with nginx server", (boolean)new RetryablePredicate((Predicate)new Predicate<HttpClient>(){

            public boolean apply(HttpClient input) {
                try {
                    int statusCode = input.executeMethod((HttpMethod)getIndex);
                    Assert.assertEquals((String)"Status code should be 200", (int)200, (int)statusCode);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, 10L, 1L, TimeUnit.SECONDS).apply((Object)client));
        String indexPageHTML = getIndex.getResponseBodyAsString();
        Assert.assertTrue((String)"The string 'nginx' should appear on the index page", (boolean)indexPageHTML.contains("nginx"));
    }

    @Test(timeout=900000L)
    public void testChefRunRecipesFromProvidedCookbooks() throws Exception {
        Recipe java = new Recipe("java");
        java.attribs.put("install_flavor", "openjdk");
        Map responses = this.runRecipe(java);
        ChefServiceTest.printResponses((Statement)java, responses);
        Statement stmt = Statements.exec((String)"java -version");
        responses = controller.runScriptOnNodesMatching(clusterSpec, allNodes, stmt);
        ChefServiceTest.assertResponsesContain(responses, stmt, "Runtime Environment");
        Recipe postgreSql = new Recipe("postgresql", "server");
        responses = this.runRecipe(postgreSql);
        ChefServiceTest.printResponses((Statement)postgreSql, responses);
        stmt = Statements.exec((String)"psql --version");
        responses = controller.runScriptOnNodesMatching(clusterSpec, allNodes, stmt);
        ChefServiceTest.assertResponsesContain(responses, stmt, "PostgreSQL");
    }

    private Map<? extends NodeMetadata, ExecResponse> runRecipe(Recipe recipe) throws IOException, RunScriptOnNodesException {
        return controller.runScriptOnNodesMatching(clusterSpec, allNodes, (Statement)recipe, Recipe.recipeScriptOptions((RunScriptOptions)controller.defaultRunScriptOptionsForSpec(clusterSpec)));
    }

    @AfterClass
    public static void tearDown() throws IOException, InterruptedException {
        if (controller != null) {
            controller.destroyCluster(clusterSpec);
        }
    }

    public static void assertResponsesContain(Map<? extends NodeMetadata, ExecResponse> responses, Statement statement, String text) {
        for (Map.Entry<? extends NodeMetadata, ExecResponse> entry : responses.entrySet()) {
            if (entry.getValue().getOutput().contains(text)) continue;
            Assert.failNotEquals((String)("Node: " + entry.getKey().getId() + " failed to execute the command: " + statement + " as could not find expected text"), (Object)text, (Object)entry.getValue());
        }
    }

    public static void printResponses(Statement statement, Map<? extends NodeMetadata, ExecResponse> responses) {
        LOG.info("Responses for Statement: " + statement);
        for (Map.Entry<? extends NodeMetadata, ExecResponse> entry : responses.entrySet()) {
            LOG.info("Node[" + entry.getKey().getId() + "]: " + entry.getValue());
        }
    }
}

