/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.chef;

import junit.framework.Assert;
import org.apache.whirr.service.chef.Recipe;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.junit.Test;

public class RecipeTest {
    private static final String NGINX_JSON = "{\"run_list\":[\"recipe[nginx]\"]}";
    private static final String POSTGRES_JSON = "{\"run_list\":[\"recipe[postgresql::server]\"]}";
    private static final String RESOLVER_JSON = "{\"resolver\":{\"nameservers\":[\"10.0.0.1\"],\"search\":\"int.example.com\"},\"run_list\":[\"recipe[resolver]\"]}";
    private static final String CHEF_COMMAND = "cat > /tmp/test.json <<-'END_OF_JCLOUDS_FILE'\n\t{\"nginx\":{\"webport\":\"90\"},\"run_list\":[\"recipe[nginx]\"]}\nEND_OF_JCLOUDS_FILE\nsudo -i chef-solo -j /tmp/test.json -r http://myurl\n";

    @Test
    public void testJSONConversion() {
        Recipe nginx = new Recipe("nginx");
        Assert.assertEquals((String)"JSON representation is incorrect.", (String)NGINX_JSON, (String)nginx.toJSON());
    }

    @Test
    public void testJSONConversionWithSpecificRecipe() {
        Recipe postgresql = new Recipe("postgresql", "server");
        Assert.assertEquals((String)"JSON representation is incorrect.", (String)POSTGRES_JSON, (String)postgresql.toJSON());
    }

    @Test
    public void testJSONConversionWithAttribs() {
        Recipe resolver = new Recipe("resolver");
        resolver.attribs.put("nameservers", new String[]{"10.0.0.1"});
        resolver.attribs.put("search", "int.example.com");
        Assert.assertEquals((String)"JSON representation is incorrect.", (String)RESOLVER_JSON, (String)resolver.toJSON());
    }

    @Test
    public void testStatementGeneration() {
        Recipe recipe = new Recipe("nginx", null, "http://myurl");
        recipe.attribs.put("webport", "90");
        recipe.fileName = "test";
        Assert.assertEquals((String)"Statement representation incorrect", (String)CHEF_COMMAND, (String)recipe.render(OsFamily.UNIX));
    }
}

