/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.chef;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.BaseServiceDryRunTest;
import org.apache.whirr.service.DryRunModule;
import org.junit.Test;

public class ChefServiceDryRunTest
extends BaseServiceDryRunTest {
    protected Set<String> getInstanceRoles() {
        return ImmutableSet.of((Object)"chef:java");
    }

    protected Predicate<CharSequence> bootstrapPredicate() {
        return Predicates.and((Predicate)Predicates.containsPattern((String)"install_ruby"), (Predicate)Predicates.containsPattern((String)"install_chef"));
    }

    protected Predicate<CharSequence> configurePredicate() {
        return Predicates.contains((Pattern)Pattern.compile("{\"run_list\":[\"recipe[java]\"]}", 16));
    }

    @Test
    public void testChefOnly() throws Exception {
        ClusterSpec chefOnly = this.newClusterSpecForProperties((Map)ImmutableMap.of((Object)"whirr.instance-templates", (Object)"1 chef"));
        DryRunModule.DryRun dryRun = this.launchWithClusterSpec(chefOnly);
        this.assertScriptPredicateOnPhase(dryRun, "bootstrap", this.bootstrapPredicate());
        this.assertNoEntryForPhase(dryRun, "configure");
    }

    @Test
    public void testChefWithDefaultRecipe() throws Exception {
        ClusterSpec cookbookWithDefaultRecipe = this.newClusterSpecForProperties((Map)ImmutableMap.of((Object)"whirr.instance-templates", (Object)"1 chef:java"));
        DryRunModule.DryRun dryRun = this.launchWithClusterSpec(cookbookWithDefaultRecipe);
        this.assertScriptPredicateOnPhase(dryRun, "bootstrap", this.bootstrapPredicate());
        this.assertScriptPredicateOnPhase(dryRun, "configure", Predicates.containsPattern((String)"chef-solo -j /tmp/java::default"));
    }

    @Test
    public void testChefWithAttributes() throws Exception {
        ClusterSpec cookbookWithSpecificRecipe = this.newClusterSpecForProperties((Map)ImmutableMap.of((Object)"whirr.instance-templates", (Object)"1 chef:java:sun"));
        DryRunModule.DryRun dryRun = this.launchWithClusterSpec(cookbookWithSpecificRecipe);
        this.assertScriptPredicateOnPhase(dryRun, "bootstrap", this.bootstrapPredicate());
        this.assertScriptPredicateOnPhase(dryRun, "configure", Predicates.containsPattern((String)"chef-solo -j /tmp/java::sun"));
    }

    @Test
    public void testChefWithParticularRecipe() throws Exception {
        ClusterSpec cookbookWithAttributes = this.newClusterSpecForProperties((Map)ImmutableMap.builder().put((Object)"whirr.instance-templates", (Object)"1 chef:java").put((Object)"java.url", (Object)"http://testurl").put((Object)"java.version", (Object)"1.5").put((Object)"java.flavor", (Object)"vanilla").build());
        DryRunModule.DryRun dryRun = this.launchWithClusterSpec(cookbookWithAttributes);
        this.assertScriptPredicateOnPhase(dryRun, "bootstrap", this.bootstrapPredicate());
        this.assertScriptPredicateOnPhase(dryRun, "configure", Predicates.contains((Pattern)Pattern.compile("{\"java\":{\"version\":\"1.5\",\"flavor\":\"vanilla\"}", 16)));
    }
}

