/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.cassandra;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.jclouds.StatementBuilder;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class CassandraClusterActionHandler
extends ClusterActionHandlerSupport {
    public static final String CASSANDRA_ROLE = "cassandra";
    public static final int CLIENT_PORT = 9160;
    public static final int JMX_PORT = 7199;
    public static final String BIN_TARBALL = "whirr.cassandra.tarball.url";
    public static final String MAJOR_VERSION = "whirr.cassandra.version.major";

    public String getRole() {
        return CASSANDRA_ROLE;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = clusterSpec.getConfiguration();
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_service", (String[])new String[0]));
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        Configuration config = clusterSpec.getConfiguration();
        String tarball = CassandraClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)config.getString(BIN_TARBALL, null));
        String major = config.getString(MAJOR_VERSION, null);
        if (tarball != null && major != null) {
            CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_cassandra", (String[])new String[]{major, tarball}));
        } else {
            CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_cassandra", (String[])new String[0]));
        }
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        Cluster cluster = event.getCluster();
        Set instances = cluster.getInstancesMatching(RolePredicates.role((String)CASSANDRA_ROLE));
        event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(instances).ports(new int[]{9160, 7199}));
        this.setInitialTokensAsEnvironmentVariables(event, instances);
        List<Cluster.Instance> seeds = this.getSeeds(instances);
        String seedServers = Joiner.on((char)' ').join(this.getPrivateIps(seeds));
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_cassandra", (String[])new String[]{seedServers}));
    }

    protected void beforeStart(ClusterActionEvent event) {
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"start_cassandra", (String[])new String[0]));
    }

    protected void beforeStop(ClusterActionEvent event) {
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"stop_cassandra", (String[])new String[0]));
    }

    protected void beforeCleanup(ClusterActionEvent event) {
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"remove_service", (String[])new String[0]));
        CassandraClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"cleanup_cassandra", (String[])new String[0]));
    }

    private List<String> getPrivateIps(List<Cluster.Instance> instances) {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                return instance.getPrivateIp();
            }
        });
    }

    protected List<Cluster.Instance> getSeeds(Set<Cluster.Instance> instances) {
        ArrayList nodes = Lists.newArrayList(instances);
        int seeds = (int)Math.ceil(Math.max(1.0, (double)instances.size() * 0.2));
        ArrayList rv = Lists.newArrayList();
        for (int i = 0; i < seeds; ++i) {
            rv.add(nodes.get(i));
        }
        return rv;
    }

    protected List<String> computeInitialTokens(int numberOfNodes) {
        ArrayList tokens = Lists.newArrayList();
        BigInteger step = new BigInteger("2").pow(127).divide(BigInteger.valueOf(numberOfNodes));
        for (int i = 0; i < numberOfNodes; ++i) {
            tokens.add(step.multiply(BigInteger.valueOf(i)).toString());
        }
        return tokens;
    }

    private void setInitialTokensAsEnvironmentVariables(ClusterActionEvent event, Set<Cluster.Instance> instances) {
        List<String> tokens = this.computeInitialTokens(instances.size());
        StatementBuilder statementBuilder = event.getStatementBuilder();
        Iterator<String> it = tokens.iterator();
        for (Cluster.Instance instance : instances) {
            statementBuilder.addExportPerInstance(instance.getId(), "cassandraInitialToken", it.next());
        }
    }
}

