/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.cassandra.integration;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraServiceTest.class);
    private ClusterSpec clusterSpec;
    private ClusterController controller;
    private Cluster cluster;

    @Before
    public void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-cassandra-test.properties"));
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterController();
        this.cluster = this.controller.launchCluster(this.clusterSpec);
        this.waitForCassandra();
    }

    private Cassandra.Client client(Cluster.Instance instance) throws TException {
        TFramedTransport trans = new TFramedTransport((TTransport)new TSocket(instance.getPublicIp(), 9160));
        trans.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)trans);
        return new Cassandra.Client((TProtocol)protocol);
    }

    private void waitForCassandra() {
        LOG.info("Waiting for Cassandra to start");
        for (Cluster.Instance instance : this.cluster.getInstances()) {
            int tries;
            for (tries = 0; tries < 30; ++tries) {
                try {
                    Cassandra.Client client = this.client(instance);
                    client.describe_cluster_name();
                    client.getOutputProtocol().getTransport().close();
                    LOG.info(instance.getPublicIp() + " is up and running");
                    break;
                }
                catch (TException e) {
                    try {
                        LOG.warn(instance.getPublicIp() + " not reachable, try #" + tries + ", waiting 1s");
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
            }
            if (tries != 10) continue;
            LOG.error("Instance " + instance.getPublicIp() + " is still unavailable after 10 retries");
        }
    }

    @Test(timeout=900000L)
    public void testInstances() throws Exception {
        LinkedHashSet endPoints = Sets.newLinkedHashSet();
        for (Cluster.Instance instance : this.cluster.getInstances()) {
            Cassandra.Client client = this.client(instance);
            Map tr = client.describe_schema_versions();
            for (List version : tr.values()) {
                endPoints.addAll(version);
            }
            client.getOutputProtocol().getTransport().close();
        }
        LOG.info("List of endpoints: " + endPoints);
        for (Cluster.Instance instance : this.cluster.getInstances()) {
            String address = instance.getPrivateAddress().getHostAddress();
            Assert.assertTrue((String)(address + " not in cluster!"), (boolean)endPoints.remove(address));
        }
        Assert.assertTrue((String)("Unknown node returned: " + ((Object)endPoints).toString()), (boolean)endPoints.isEmpty());
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        if (this.controller != null) {
            this.controller.destroyCluster(this.clusterSpec);
        }
    }
}

