/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.cassandra;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.service.cassandra.CassandraClusterActionHandler;
import org.jclouds.domain.Credentials;
import org.junit.Assert;
import org.junit.Test;

public class CassandraClusterActionHandlerTest {
    private Cluster.Instance getInstance(String id) throws UnknownHostException {
        return new Cluster.Instance(new Credentials("", ""), (Set)Sets.newHashSet((Object[])new String[]{""}), "127.0.0.1", "127.0.0.1", id, null);
    }

    @Test
    public void testGetSeeds() throws UnknownHostException {
        Cluster.Instance one = this.getInstance("1");
        Cluster.Instance two = this.getInstance("2");
        LinkedHashSet instances = Sets.newLinkedHashSet();
        instances.add(one);
        CassandraClusterActionHandler handler = new CassandraClusterActionHandler();
        List seeds1 = handler.getSeeds((Set)instances);
        Assert.assertEquals((long)1L, (long)seeds1.size());
        Assert.assertEquals((Object)one, seeds1.get(0));
        instances.add(two);
        for (int i = 3; i < 10; ++i) {
            instances.add(this.getInstance(Integer.toString(i)));
        }
        List seeds2 = handler.getSeeds((Set)instances);
        Assert.assertEquals((long)2L, (long)seeds2.size());
        Assert.assertEquals((Object)one, seeds2.get(0));
        Assert.assertEquals((Object)two, seeds2.get(1));
    }

    @Test
    public void testComputeInitialTokens() {
        List result = new CassandraClusterActionHandler().computeInitialTokens(5);
        Assert.assertEquals((Object)result, (Object)ImmutableList.of((Object)"0", (Object)"34028236692093846346337460743176821145", (Object)"68056473384187692692674921486353642290", (Object)"102084710076281539039012382229530463435", (Object)"136112946768375385385349842972707284580"));
    }
}

