/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.tez.mapreduce.examples.TestOrderedWordCount;
import org.apache.tez.test.MiniTezCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSecureShuffle {
    private static MiniDFSCluster miniDFSCluster;
    private static MiniTezCluster miniTezCluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static Path inputLoc;
    private static String TEST_ROOT_DIR;
    private static File keysStoresDir;
    private boolean enableSSLInCluster;
    private int resultWithTezSSL;
    private int resultWithoutTezSSL;

    public TestSecureShuffle(boolean sslInCluster, int resultWithTezSSL, int resultWithoutTezSSL) {
        this.enableSSLInCluster = sslInCluster;
        this.resultWithTezSSL = resultWithTezSSL;
        this.resultWithoutTezSSL = resultWithoutTezSSL;
    }

    @Parameterized.Parameters(name="test[sslInCluster:{0}, resultWithTezSSL:{1}, resultWithoutTezSSL:{2}]")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{true, 0, 1});
        parameters.add(new Object[]{false, 1, 0});
        return parameters;
    }

    @BeforeClass
    public static void setupDFSCluster() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.edits.noeditlogchannelflush", false);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
        miniDFSCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        fs = miniDFSCluster.getFileSystem();
        conf.set("fs.defaultFS", fs.getUri().toString());
    }

    @AfterClass
    public static void shutdownDFSCluster() {
        if (miniDFSCluster != null) {
            miniDFSCluster.shutdown();
        }
    }

    @Before
    public void setupTezCluster() throws Exception {
        if (this.enableSSLInCluster) {
            System.setProperty("javax.net.debug", "all");
            TestSecureShuffle.setupKeyStores();
        }
        conf.setBoolean("mapreduce.shuffle.ssl.enabled", this.enableSSLInCluster);
        conf.setInt("tez.runtime.shuffle.connect.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.read.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.fetch.failures.limit", 2);
        miniTezCluster = new MiniTezCluster(TestSecureShuffle.class.getName() + "-" + (this.enableSSLInCluster ? "withssl" : "withoutssl"), 1, 1, 1);
        miniTezCluster.init(conf);
        miniTezCluster.start();
        TestSecureShuffle.createSampleFile(inputLoc);
    }

    @After
    public void shutdownTezCluster() throws IOException {
        if (miniTezCluster != null) {
            miniTezCluster.stop();
        }
    }

    private void baseTest(int expectedResult) throws Exception {
        Path outputLoc = new Path("/tmp/outPath_" + System.currentTimeMillis());
        TestOrderedWordCount wordCount = new TestOrderedWordCount();
        wordCount.setConf(new Configuration(miniTezCluster.getConfig()));
        String[] args = new String[]{inputLoc.toString(), outputLoc.toString()};
        Assert.assertEquals((long)expectedResult, (long)wordCount.run(args));
    }

    @Test(timeout=240000L)
    public void testSecureShuffle() throws Exception {
        miniTezCluster.getConfig().setBoolean("tez.runtime.shuffle.ssl.enable", true);
        this.baseTest(this.resultWithTezSSL);
        miniTezCluster.getConfig().setBoolean("tez.runtime.shuffle.ssl.enable", false);
        this.baseTest(this.resultWithoutTezSSL);
    }

    private static void createSampleFile(Path inputLoc) throws IOException {
        fs.deleteOnExit(inputLoc);
        FSDataOutputStream out = fs.create(inputLoc);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out));
        for (int i = 0; i < 10; ++i) {
            writer.write("Hello World");
            writer.write("Some other line");
            writer.newLine();
        }
        writer.close();
    }

    private static void setupKeyStores() throws Exception {
        keysStoresDir.mkdirs();
        String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestSecureShuffle.class);
        KeyStoreTestUtil.setupSSLConfig((String)keysStoresDir.getAbsolutePath(), (String)sslConfsDir, (Configuration)conf, (boolean)true);
    }

    static {
        conf = new Configuration();
        inputLoc = new Path("/tmp/sample.txt");
        TEST_ROOT_DIR = "target/" + TestSecureShuffle.class.getName() + "-tmpDir";
        keysStoresDir = new File(TEST_ROOT_DIR, "keystores");
    }
}

