/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;

public class FaultToleranceTestRunner {
    static String TEST_ROOT_DIR = "tmp";
    Configuration conf = null;
    TezClient tezSession = null;
    Resource defaultResource = Resource.newInstance((int)100, (int)0);

    void setup() throws Exception {
        TezConfiguration tezConf = null;
        tezConf = this.conf == null ? new TezConfiguration((Configuration)new YarnConfiguration()) : new TezConfiguration((Configuration)new YarnConfiguration(this.conf));
        FileSystem defaultFs = FileSystem.get((Configuration)tezConf);
        Path remoteStagingDir = defaultFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        TezClientUtils.ensureStagingDirExists((Configuration)tezConf, (Path)remoteStagingDir);
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        this.tezSession = TezClient.create((String)"FaultToleranceTestRunner", (TezConfiguration)tezConf);
        this.tezSession.start();
    }

    void tearDown() throws Exception {
        if (this.tezSession != null) {
            this.tezSession.stop();
        }
    }

    DAG getDAG(String className, String confFilePath) throws Exception {
        Class<?> clazz = Class.forName(className);
        Method method = clazz.getMethod("createDAG", Configuration.class);
        Configuration testConf = new Configuration(false);
        if (confFilePath != null) {
            Path confPath = new Path(confFilePath);
            testConf.addResource(confPath);
        }
        DAG dag = (DAG)method.invoke(null, testConf);
        return dag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean run(Configuration conf, String className, String confFilePath) throws Exception {
        this.conf = conf;
        this.setup();
        try {
            this.tezSession.waitTillReady();
            DAG dag = this.getDAG(className, confFilePath);
            DAGClient dagClient = this.tezSession.submitDAG(dag);
            DAGStatus dagStatus = dagClient.getDAGStatus(null);
            while (!dagStatus.isCompleted()) {
                System.out.println("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appContext: " + dagClient.getExecutionContext() + " Current state: " + dagStatus.getState());
                Thread.sleep(500L);
                dagStatus = dagClient.getDAGStatus(null);
            }
            if (dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.tearDown();
        }
        return false;
    }

    static void printUsage() {
        System.err.println("Usage:  FaultToleranceTestRunner [generic options] <dag-class-name> <test-conf-path>");
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        String className = null;
        String confFilePath = null;
        if (otherArgs.length == 1) {
            className = otherArgs[0];
        } else if (otherArgs.length == 2) {
            className = otherArgs[0];
            confFilePath = otherArgs[1];
        } else {
            FaultToleranceTestRunner.printUsage();
            System.exit(1);
        }
        FaultToleranceTestRunner job = new FaultToleranceTestRunner();
        if (job.run(conf, className, confFilePath)) {
            System.out.println("Succeeded.");
        } else {
            System.out.println("Failed.");
            System.exit(2);
        }
    }
}

