/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test.dag;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestProcessor;
import org.apache.tez.test.dag.ThreeLevelsFailingDAG;

public class SixLevelsFailingDAG
extends ThreeLevelsFailingDAG {
    protected static Vertex l4v1;
    protected static Vertex l5v1;
    protected static Vertex l5v2;
    protected static Vertex l5v3;
    protected static Vertex l6v1;

    protected static void addDAGVerticesAndEdges() {
        ThreeLevelsFailingDAG.addDAGVerticesAndEdges();
        l4v1 = new Vertex("l4v1", TestProcessor.getProcDesc(payload), 10, defaultResource);
        dag.addVertex(l4v1);
        SixLevelsFailingDAG.addEdge(l3v1, l4v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        SixLevelsFailingDAG.addEdge(l3v2, l4v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l5v1 = new Vertex("l5v1", TestProcessor.getProcDesc(payload), 2, defaultResource);
        dag.addVertex(l5v1);
        SixLevelsFailingDAG.addEdge(l4v1, l5v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l5v2 = new Vertex("l5v2", TestProcessor.getProcDesc(payload), 4, defaultResource);
        dag.addVertex(l5v2);
        SixLevelsFailingDAG.addEdge(l4v1, l5v2, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l5v3 = new Vertex("l5v3", TestProcessor.getProcDesc(payload), 1, defaultResource);
        dag.addVertex(l5v3);
        SixLevelsFailingDAG.addEdge(l4v1, l5v3, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l6v1 = new Vertex("l6v1", TestProcessor.getProcDesc(payload), 4, defaultResource);
        dag.addVertex(l6v1);
        SixLevelsFailingDAG.addEdge(l5v1, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        SixLevelsFailingDAG.addEdge(l5v2, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        SixLevelsFailingDAG.addEdge(l5v3, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
    }

    public static DAG createDAG(String name, Configuration conf) throws Exception {
        if (conf != null) {
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        dag = new DAG(name);
        SixLevelsFailingDAG.addDAGVerticesAndEdges();
        return dag;
    }

    public static DAG createDAG(Configuration conf) throws Exception {
        return SixLevelsFailingDAG.createDAG("SixLevelsFailingDAG", conf);
    }
}

