/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test.dag;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;

public class SimpleVTestDAG {
    static Resource defaultResource = Resource.newInstance((int)100, (int)0);
    public static String TEZ_SIMPLE_V_DAG_NUM_TASKS = "tez.simple-v-test-dag.num-tasks";
    public static int TEZ_SIMPLE_V_DAG_NUM_TASKS_DEFAULT = 2;

    public static DAG createDAG(String name, Configuration conf) throws Exception {
        byte[] payload = null;
        int taskCount = TEZ_SIMPLE_V_DAG_NUM_TASKS_DEFAULT;
        if (conf != null) {
            taskCount = conf.getInt(TEZ_SIMPLE_V_DAG_NUM_TASKS, TEZ_SIMPLE_V_DAG_NUM_TASKS_DEFAULT);
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        DAG dag = new DAG(name);
        Vertex v1 = new Vertex("v1", TestProcessor.getProcDesc(payload), taskCount, defaultResource);
        Vertex v2 = new Vertex("v2", TestProcessor.getProcDesc(payload), taskCount, defaultResource);
        Vertex v3 = new Vertex("v3", TestProcessor.getProcDesc(payload), taskCount, defaultResource);
        dag.addVertex(v1).addVertex(v2).addVertex(v3);
        dag.addEdge(new Edge(v1, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, TestOutput.getOutputDesc(payload), TestInput.getInputDesc(payload))));
        dag.addEdge(new Edge(v2, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, TestOutput.getOutputDesc(payload), TestInput.getInputDesc(payload))));
        return dag;
    }

    public static DAG createDAG(Configuration conf) throws Exception {
        return SimpleVTestDAG.createDAG("SimpleVTestDAG", conf);
    }
}

