/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezSession;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;

public class FaultToleranceTestRunner {
    static String TEST_ROOT_DIR = "tmp";
    TezSession tezSession = null;
    Resource defaultResource = Resource.newInstance((int)100, (int)0);

    void setup() throws Exception {
        TezConfiguration tezConf = new TezConfiguration((Configuration)new YarnConfiguration());
        FileSystem defaultFs = FileSystem.get((Configuration)tezConf);
        Path remoteStagingDir = defaultFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        TezClientUtils.ensureStagingDirExists((Configuration)tezConf, (Path)remoteStagingDir);
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        AMConfiguration amConfig = new AMConfiguration(new HashMap(), new HashMap(), tezConf, null);
        TezSessionConfiguration tezSessionConfig = new TezSessionConfiguration(amConfig, tezConf);
        this.tezSession = new TezSession("FaultToleranceTestRunner", tezSessionConfig);
        this.tezSession.start();
    }

    void tearDown() throws Exception {
        if (this.tezSession != null) {
            this.tezSession.stop();
        }
    }

    DAG getDAG(String className, String confFilePath) throws Exception {
        Class<?> clazz = Class.forName(className);
        Method method = clazz.getMethod("createDAG", Configuration.class);
        Configuration testConf = new Configuration(false);
        if (confFilePath != null) {
            Path confPath = new Path(confFilePath);
            testConf.addResource(confPath);
        }
        DAG dag = (DAG)method.invoke(null, testConf);
        return dag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean run(String className, String confFilePath) throws Exception {
        this.setup();
        try {
            TezSessionStatus status = this.tezSession.getSessionStatus();
            while (status != TezSessionStatus.READY && status != TezSessionStatus.SHUTDOWN) {
                System.out.println("Waiting for session to be ready. Current: " + status);
                Thread.sleep(500L);
                status = this.tezSession.getSessionStatus();
            }
            if (status == TezSessionStatus.SHUTDOWN) {
                throw new TezUncheckedException("Unexpected Session shutdown");
            }
            DAG dag = this.getDAG(className, confFilePath);
            DAGClient dagClient = this.tezSession.submitDAG(dag);
            DAGStatus dagStatus = dagClient.getDAGStatus(null);
            while (!dagStatus.isCompleted()) {
                System.out.println("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appId: " + dagClient.getApplicationId() + " Current state: " + dagStatus.getState());
                Thread.sleep(500L);
                dagStatus = dagClient.getDAGStatus(null);
            }
            if (dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.tearDown();
        }
        return false;
    }

    static void printUsage() {
        System.err.println("Usage:  FaultToleranceTestRunner <dag-class-name> <test-conf-path>");
    }

    public static void main(String[] args) throws Exception {
        String className = null;
        String confFilePath = null;
        if (args.length == 1) {
            className = args[0];
        } else if (args.length == 2) {
            className = args[0];
            confFilePath = args[1];
        } else {
            FaultToleranceTestRunner.printUsage();
            System.exit(1);
        }
        FaultToleranceTestRunner job = new FaultToleranceTestRunner();
        if (job.run(className, confFilePath)) {
            System.out.println("Succeeded.");
        } else {
            System.out.println("Failed.");
            System.exit(2);
        }
    }
}

