/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.library.common.InputIdentifier;

@InterfaceAudience.Private
public class InputAttemptIdentifier {
    private final InputIdentifier inputIdentifier;
    private final int attemptNumber;
    private final String pathComponent;
    private final boolean shared;
    public static final String PATH_PREFIX = "attempt";

    public InputAttemptIdentifier(int inputIndex, int attemptNumber) {
        this(new InputIdentifier(inputIndex), attemptNumber, null);
    }

    public InputAttemptIdentifier(InputIdentifier inputIdentifier, int attemptNumber, String pathComponent) {
        this(inputIdentifier, attemptNumber, pathComponent, false);
    }

    public InputAttemptIdentifier(InputIdentifier inputIdentifier, int attemptNumber, String pathComponent, boolean shared) {
        this.inputIdentifier = inputIdentifier;
        this.attemptNumber = attemptNumber;
        this.pathComponent = pathComponent;
        this.shared = shared;
        if (pathComponent != null && !pathComponent.startsWith(PATH_PREFIX)) {
            throw new TezUncheckedException("Path component must start with: attempt " + this);
        }
    }

    public InputAttemptIdentifier(int taskIndex, int attemptNumber, String pathComponent) {
        this(new InputIdentifier(taskIndex), attemptNumber, pathComponent);
    }

    public InputAttemptIdentifier(int taskIndex, int attemptNumber, String pathComponent, boolean shared) {
        this(new InputIdentifier(taskIndex), attemptNumber, pathComponent, shared);
    }

    public InputIdentifier getInputIdentifier() {
        return this.inputIdentifier;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String getPathComponent() {
        return this.pathComponent;
    }

    public boolean isShared() {
        return this.shared;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attemptNumber;
        result = 31 * result + (this.inputIdentifier == null ? 0 : this.inputIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputAttemptIdentifier other = (InputAttemptIdentifier)obj;
        if (this.attemptNumber != other.attemptNumber) {
            return false;
        }
        return !(this.inputIdentifier == null ? other.inputIdentifier != null : !this.inputIdentifier.equals(other.inputIdentifier));
    }

    public String toString() {
        return "InputAttemptIdentifier [inputIdentifier=" + this.inputIdentifier + ", attemptNumber=" + this.attemptNumber + ", pathComponent=" + this.pathComponent + "]";
    }
}

