/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestUnorderedPartitionedKVOutputConfig {
    @Test
    public void testNullParams() {
        try {
            UnorderedPartitionedKVOutputConfig.newBuilder(null, (String)"VALUE", (String)"PARTITIONER", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedPartitionedKVOutputConfig.newBuilder((String)"KEY", null, (String)"PARTITIONER", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", null, null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test
    public void testSetters() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.ifile.readahead.bytes", 1111);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("test.key.2", "key2");
        additionalConf.put("tez.runtime.unordered.output.max-per-buffer.size-bytes", "2222");
        additionalConf.put("file.shouldExist", "file");
        UnorderedPartitionedKVOutputConfig.Builder builder = UnorderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", null).setCompression(true, "CustomCodec", null).setAvailableBufferSize(1111).setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("tez.runtime.ifile.readahead", String.valueOf(false)).setAdditionalConfiguration(additionalConf).setFromConfiguration(fromConf);
        UnorderedPartitionedKVOutputConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuilt = new UnorderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.unordered.output.buffer.size-mb", 0));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)conf.get("tez.runtime.partitioner.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000));
        Assert.assertEquals((long)2222L, (long)conf.getInt("tez.runtime.unordered.output.max-per-buffer.size-bytes", 0));
        Assert.assertEquals((Object)"io", (Object)conf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)conf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)conf.get("fs.shouldExist"));
        Assert.assertNull((Object)conf.get("test.conf.key.1"));
        Assert.assertNull((Object)conf.get("test.key.1"));
        Assert.assertNull((Object)conf.get("test.key.2"));
    }

    @Test
    public void testDefaultConfigsUsed() {
        UnorderedPartitionedKVOutputConfig.Builder builder = UnorderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", null).setKeySerializationClass("SerClass1", null).setValueSerializationClass("SerClass2", null);
        UnorderedPartitionedKVOutputConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuilt = new UnorderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)conf.get("tez.runtime.partitioner.class", ""));
        Assert.assertTrue((boolean)conf.get("io.serializations").startsWith("SerClass2,SerClass1"));
        Assert.assertNull((Object)conf.get("tez.runtime.key.comparator.class"));
    }

    @Test
    public void testPartitionerConfigs() {
        HashMap partitionerConf = Maps.newHashMap();
        partitionerConf.put("partitioner.test.key", "PARTITIONERKEY");
        partitionerConf.put("tez.runtime.compress.codec", "InvalidKeyOverride");
        UnorderedPartitionedKVOutputConfig.Builder builder = UnorderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", (Map)partitionerConf);
        UnorderedPartitionedKVOutputConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuilt = new UnorderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"PARTITIONERKEY", (Object)conf.get("partitioner.test.key"));
    }
}

