/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.UnorderedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVInputConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestUnorderedKVEdgeConfig {
    @Test
    public void testNullParams() {
        try {
            UnorderedKVEdgeConfig.newBuilder(null, (String)"VALUE");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedKVEdgeConfig.newBuilder((String)"KEY", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test
    public void testDefaultConfigsUsed() {
        UnorderedKVEdgeConfig.Builder builder = UnorderedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE");
        builder.setKeySerializationClass("SerClass1", null).setValueSerializationClass("SerClass2", null);
        UnorderedKVEdgeConfig configuration = builder.build();
        UnorderedKVOutputConfig rebuiltOutput = new UnorderedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)true, (Object)outputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertTrue((boolean)outputConf.get("io.serializations").startsWith("SerClass2,SerClass1"));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)true, (Object)inputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertTrue((boolean)inputConf.get("io.serializations").startsWith("SerClass2,SerClass1"));
    }

    @Test
    public void testSpecificIOConfs() {
        UnorderedKVEdgeConfig.Builder builder = UnorderedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE");
        UnorderedKVEdgeConfig configuration = builder.build();
        UnorderedKVOutputConfig rebuiltOutput = new UnorderedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", "DEFAULT"));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", "DEFAULT"));
    }

    @Test
    public void tetCommonConf() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setBoolean("tez.runtime.ifile.readahead", false);
        fromConf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.11f);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConfs = new HashMap<String, String>();
        additionalConfs.put("test.key.2", "key2");
        additionalConfs.put("tez.runtime.ifile.readahead.bytes", "1111");
        additionalConfs.put("tez.runtime.shuffle.memory.limit.percent", "0.22f");
        additionalConfs.put("file.shouldExist", "file");
        UnorderedKVEdgeConfig.Builder builder = UnorderedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE").setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("io.file.buffer.size", "3333").setAdditionalConfiguration("tez.runtime.shuffle.merge.percent", "0.33f").setAdditionalConfiguration(additionalConfs).setFromConfiguration(fromConf);
        UnorderedKVEdgeConfig configuration = builder.build();
        UnorderedKVOutputConfig rebuiltOutput = new UnorderedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)false, (Object)outputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)outputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)3333L, (long)outputConf.getInt("io.file.buffer.size", 0));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.fetch.buffer.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.memory.limit.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.merge.percent"));
        Assert.assertEquals((Object)"io", (Object)outputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)outputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)outputConf.get("fs.shouldExist"));
        Assert.assertEquals((Object)false, (Object)inputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)inputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)3333L, (long)inputConf.getInt("io.file.buffer.size", 0));
        Assert.assertEquals((float)0.11f, (float)inputConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)inputConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)inputConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((Object)"io", (Object)inputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)inputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)inputConf.get("fs.shouldExist"));
    }
}

